--
-- Henly20 (Ls_uk Modteam)
-- 23.08.2010
--
-- > www.LS-UK.info

FordForce7000 = {};

function FordForce7000.initSpecialization()

end;

function FordForce7000.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function FordForce7000:load(xmlFile)

	self.indicatorsLever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indicatorsLever#index"));
	local rotationRpmNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationRpm#index"));
		if rotationRpmNode ~= nil then
        self.rotationRpm = {};
        self.rotationRpm.node = rotationRpmNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#minRot"));
        self.rotationRpm.minRot = {};
        self.rotationRpm.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#maxRot"));
        self.rotationRpm.maxRot = {};
        self.rotationRpm.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationRpm.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#rotTime"), 2)*1000;
        self.rotationRpm.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#touchRotLimit"), 10));
    end;
	local rotationFuelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationFuel#index"));
		if rotationFuelNode ~= nil then
        self.rotationFuel = {};
        self.rotationFuel.node = rotationFuelNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFuel#minRot"));
        self.rotationFuel.minRot = {};
        self.rotationFuel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFuel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFuel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFuel#maxRot"));
        self.rotationFuel.maxRot = {};
        self.rotationFuel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFuel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFuel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFuel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFuel#rotTime"), 2)*1000;
        self.rotationFuel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFuel#touchRotLimit"), 10));
    end;
	local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
		if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
    end;
	local rotationPartNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart8#index"));
    if rotationPartNode8 ~= nil then
        self.rotationPart8 = {};
        self.rotationPart8.node = rotationPartNode8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#minRot"));
        self.rotationPart8.minRot = {};
        self.rotationPart8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#maxRot"));
        self.rotationPart8.maxRot = {};
        self.rotationPart8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#rotTime"), 2)*1000;
        self.rotationPart8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#touchRotLimit"), 10));
    end;
	local rotationPartNode10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart10#index"));
    if rotationPartNode10 ~= nil then
        self.rotationPart10 = {};
        self.rotationPart10.node = rotationPartNode10;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart10#minRot"));
        self.rotationPart10.minRot = {};
        self.rotationPart10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart10#maxRot"));
        self.rotationPart10.maxRot = {};
        self.rotationPart10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart10#rotTime"), 2)*1000;
        self.rotationPart10.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart10#touchRotLimit"), 10));
    end;
	local rotationPartNode11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart11#index"));
    if rotationPartNode11 ~= nil then
        self.rotationPart11 = {};
        self.rotationPart11.node = rotationPartNode11;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart11#minRot"));
        self.rotationPart11.minRot = {};
        self.rotationPart11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart11#maxRot"));
        self.rotationPart11.maxRot = {};
        self.rotationPart11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart11#rotTime"), 2)*1000;
        self.rotationPart11.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart11#touchRotLimit"), 10));
    end;
	
	self.rotationMax4Active = false;
	self.rotationMax8Active = false;
	self.rotationMax9Active = false;
	self.rotationMax10 = true;
	
	local rotationLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Lifter#index"));
	self.Lifter = {};
	self.Lifter.node = rotationLifter;

	local rotationLifterArm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterArm#index"));
	self.LifterArm = {};
	self.LifterArm.node = rotationLifterArm;

	local rotationLifterBottom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterBottom#index"));
	self.bottomArm2 = {};
	self.bottomArm2.node = rotationLifterBottom;
    
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;

    self.fanNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fan#index"));

    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
	self.isSelectable = true;
end;

function FordForce7000:readStream(streamId, connection)

end;
  
function FordForce7000:writeStream(streamId, connection)

end;

function FordForce7000:keyEvent(unicode, sym, modifier, isDown)

end;

function FordForce7000:update(dt)
	if self:getIsActiveForInput() and self.isEntered then   
        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self.rotationMax10 = not self.rotationMax10;
        end;	
	end;	
	
	if self:getIsActive() then	
		inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
		
		if self.isEntered ~= nil then
			if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
				self.rotationMax4Active = true;
				self.rotationMax8Active = true;
			else
				self.rotationMax4Active = false;
				self.rotationMax8Active = false;
			end;
		end;
	
		local maxrpmneedle = 2800;
		if self.rotationRpm ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationRpm.node);
			y = ((self.rotationRpm.maxRot[2] - self.rotationRpm.minRot[2]) / maxrpmneedle) * (self.motor.lastMotorRpm+400) + self.rotationRpm.minRot[2];
			setRotation(self.rotationRpm.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationRpm.node, 0, 0 ,0);
		end;
		local maxfuelguage = 75;
		if self.rotationFuel ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationFuel.node);
			y = ((self.rotationFuel.maxRot[2] - self.rotationFuel.minRot[2]) / maxfuelguage) * self.fuelFillLevel + self.rotationFuel.minRot[2];
			setRotation(self.rotationFuel.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationFuel.node, 0, 0 ,0);
		end;
		if self.rotationPart4 ~= nil then
			local x, y, z = getRotation(self.rotationPart4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4Active);
			setRotation(self.rotationPart4.node, unpack(newRot));
		end;
		if self.rotationPart8 ~= nil then
			local x, y, z = getRotation(self.rotationPart8.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart8.maxRot, self.rotationPart8.minRot, 3, self.rotationPart8.rotTime, dt, not self.rotationMax8Active);
			setRotation(self.rotationPart8.node, unpack(newRot));
		end;
		if self.rotationPart10 ~= nil then
			local x, y, z = getRotation(self.rotationPart10.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart10.maxRot, self.rotationPart10.minRot, 3, self.rotationPart10.rotTime, dt, not self.rotationMax10);
			setRotation(self.rotationPart10.node, unpack(newRot));
		end;	
		local maxhandthrottle = 2800;
		if self.rotationPart11 ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationPart11.node);
			x = ((self.rotationPart11.maxRot[1] - self.rotationPart11.minRot[1]) / maxrpmneedle) * (self.motor.lastMotorRpm+400) + self.rotationPart11.minRot[1];
			setRotation(self.rotationPart11.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationPart11.node, 0, 0 ,0);
		end;
		
		if self.Lifter.node ~= nil and self.bottomArm2.node ~= nil then
			rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
			setRotation(self.Lifter.node, rBBArmX*1.05, 0, 0);
		end;
		if self.LifterArm.node ~= nil and self.bottomArm2.node ~= nil then
			setRotation(self.LifterArm.node, 0.05-rBBArmX*1.1, 0, 0);
		end;
	end;
		if self:getIsActive() then			
			self.setHydraulicTime = 30;	
		end;

		if self.setHydraulicTime > 0 then
			for k,v in pairs(self.hydraulics) do 
				self:setHydraulicDirection(k);
			end;
			self.setHydraulicTime = self.setHydraulicTime - 1;
		end;	
		if self.fanNode ~= nil and self.isMotorStarted then 
			 rotate(self.fanNode, 0, 0, self.motor.lastMotorRpm*4);
		end;	
end;

function FordForce7000:updateTick(dt)
	if self:getIsActive() then	
	
		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;	
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;	
	end;
end;

function FordForce7000:draw()
  
end;

function FordForce7000:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;  
end;

function FordForce7000:onLeave()
 	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function FordForce7000:delete()

end;

function FordForce7000:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function FordForce7000:mouseEvent(posX, posY, isDown, isUp, button)
end;
