--
-- Specialization for Animations
-- This script can be used to play animations that use the AnimatedVehicle specializations
--
--
-- @author:		Marcu Hedblom a.k.a Xentro (www.ls-uk.info)
-- @email:		Marcus@Xentro.se
-- @version:	v1.0
-- @date:		22/10/11
-- @history:	v1.0 - inital implementation
--
--


-- <standardAnimations>
--	   <part name="animationName" inputName="BUTTONNAME" helpTextNamePos="110n_help_text_open" helpTextNameNeg="110n_help_text_close" />
-- </standardAnimations>

PlayStandAnim = {};

function PlayStandAnim.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function PlayStandAnim:load(xmlFile)
	print("PlayStandAnim:load("..xmlFile..")");
	
	self.setPlayAnim = SpecializationUtil.callSpecializationsFunction("setPlayAnim");

	self.PAs = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.standardAnimations.part(%d)", i);
		if not hasXMLProperty(xmlFile, baseName) then
			break;
        end;
		local PA = {};
		PA.aName = getXMLString(xmlFile, baseName .. "#name");
		PA.inputName = getXMLString(xmlFile, baseName .. "#inputName");
		if PA.aName == nil or InputBinding[PA.inputName] == nil then
			break;
		end;
			
		PA.helpTextNameP = getXMLString(xmlFile, baseName .. "#helpTextNamePos");
		PA.helpTextNameN = getXMLString(xmlFile, baseName .. "#helpTextNameNeg");
		
		if g_i18n:hasText(PA.helpTextNameP) or g_i18n:hasText(PA.helpTextNameN) then PA.helpText = true; else PA.helpText = false; end;
		if g_i18n:hasText(PA.helpTextNameP) and g_i18n:hasText(PA.helpTextNameN) then PA.multiHelpText = true; else PA.multiHelpText = false; end;
			
		PA.aFinished = false;
		
		table.insert(self.PAs, PA);
		i = i+1;
	end;
end;

function PlayStandAnim:delete()
end;

function PlayStandAnim:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PlayStandAnim:keyEvent(unicode, sym, modifier, isDown)
end;

function PlayStandAnim:readStream(streamId, connection)
	for k,v in ipairs(self.PAs) do
		local state = streamReadBool(streamId);
		self:setPlayAnim(k,state,true);
	end;
end;
	
function PlayStandAnim:writeStream(streamId, connection)
	for k,v in ipairs(self.PAs) do
		streamWriteBool(streamId, v.aFinished);
	end;
end;

function PlayStandAnim:update(dt)
	if self:getIsActiveForInput() then
		for k,v in ipairs(self.PAs) do
			if InputBinding.hasEvent(InputBinding[v.inputName]) then
				self:setPlayAnim(k, not v.aFinished); 
			end;
		end;
	end;
end;

function PlayStandAnim:draw()
	if g_currentMission.showHelpText then
		for k,v in ipairs(self.PAs) do
			if v.helpText then
				if v.multiHelpText then
					if v.aFinished then
						g_currentMission:addHelpButtonText(g_i18n:getText(v.helpTextNameN), InputBinding[v.inputName]);
					else
						g_currentMission:addHelpButtonText(g_i18n:getText(v.helpTextNameP), InputBinding[v.inputName]);
					end;
				else
					if v.helpTextNameP ~= nil then
						g_currentMission:addHelpButtonText(g_i18n:getText(v.helpTextNameP), InputBinding[v.inputName]);
					elseif v.helpTextNameN ~= nil and v.helpTextNameP == nil then
						g_currentMission:addHelpButtonText(g_i18n:getText(v.helpTextNameN), InputBinding[v.inputName]);
					end;
				end;
			end;
		end;
	end;
end;

function PlayStandAnim:setPlayAnim(id,state,noEventSend)
	local v = self.PAs[id];
	if state then
		if v.aName ~= nil and self.playAnimation ~= nil then
			self:playAnimation(v.aName, 1, nil, true);
			v.aFinished = state;
		end;
	else
		if v.aName ~= nil and self.playAnimation ~= nil then
			self:playAnimation(v.aName, -1, nil, true);
			v.aFinished = state;
		end;
	end;
	setPlayAnimeEvent.sendEvent(self,id,state,noEventSend);
end;

-- Event --
setPlayAnimeEvent = {};
setPlayAnimeEvent_mt = Class(setPlayAnimeEvent, Event);
InitEventClass(setPlayAnimeEvent, "setPlayAnimeEvent");

function setPlayAnimeEvent:emptyNew()
    local self = Event:new(setPlayAnimeEvent_mt);
    self.className="setPlayAnimeEvent";
    return self;
end;

function setPlayAnimeEvent:new(object, id, state)
	local self = setPlayAnimeEvent:emptyNew()
	self.object = object;
	self.id = id;
	self.state = state;
	return self;
end;

function setPlayAnimeEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.id  = streamReadInt8(streamId);
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function setPlayAnimeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.id);
	streamWriteBool(streamId, self.state);
end;

function setPlayAnimeEvent:run(connection)
	self.object:setPlayAnim(self.id,self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(setPlayAnimeEvent:new(self.object, self.id, self.state), nil, connection, self.object);
	end;	
end;

function setPlayAnimeEvent.sendEvent(vehicle, id, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setPlayAnimeEvent:new(vehicle, id, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setPlayAnimeEvent:new(vehicle, id, state));
		end;
	end;
end;