--
-- Specialization CattleTrailerTipAreaEvent
-- This script select the TipAnimation/TipReferencePoint based on the fruitType/fillType
--
--
-- @author:		Jengske_BE  (www.international-modding.eu)
-- @email:		ponystal-peeters@telenet.be
-- @version:	v1.0
-- @date:		22/01/14
-- @history:	v1.0 - inital implementation
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
  
CTrailerTipAreaEvent = {};
CTrailerTipAreaEvent_mt = Class(CTrailerTipAreaEvent, Event);
 
--InitStaticEventClass
InitEventClass(CTrailerTipAreaEvent, "CTrailerTipAreaEvent", EventIds.EVENT_CTRAILER_TIP_AREA);
   
 function CTrailerTipAreaEvent:emptyNew()
        local self = Event:new(CTrailerTipAreaEvent_mt);
      return self;
  end;
  
function CTrailerTipAreaEvent:new(area, bitType, fillType)
       local self = CTrailerTipAreaEvent:emptyNew()
       self.area = area;
      self.bitType = bitType;
       self.fillType = fillType;
       assert(self.bitType >= 0 and self.bitType <= 3);
     return self;
end;
  
function CTrailerTipAreaEvent:readStream(streamId, connection)
  
      local fillType = streamReadUIntN(streamId, Fillable.sendNumBits);
   local groundValueId = g_currentMission.groundValueIds[fillType];
     local amountPerPixel = streamReadUIntN(streamId, groundValueId.numChannels);
   
      local refX = streamReadFloat32(streamId);
       local refY = streamReadFloat32(streamId);
    local values = Utils.readCompressed2DVectors(streamId, refX, refY, 2, 0.01, true);
 
      local x = values[1].x;
      local z = values[1].y;
       local x1 = values[2].x;
        local z1 = values[2].y;
      local x2 = values[3].x;
     local z2 = values[3].y;
 
     Utils.addGroundValueAreaPerPixel(groundValueId.id, groundValueId.firstChannel, groundValueId.numChannels, x, z, x1, z1, x2, z2, amountPerPixel)
end;
 
function CTrailerTipAreaEvent:writeStream(streamId, connection)
   
      streamWriteUIntN(streamId, self.fillType, Fillable.sendNumBits);
      local groundValueId = g_currentMission.groundValueIds[self.fillType];
       streamWriteUIntN(streamId, self.area[8], groundValueId.numChannels);
    
       local d = self.area;
       local refX, refY = d[1], d[2];
        streamWriteFloat32(streamId, d[1]);
        streamWriteFloat32(streamId, d[2]);
       local values = { {x=d[3], y=d[4]}, {x=d[5], y=d[6]} };
    
        Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01, self.bitType);
end;
   
function CTrailerTipAreaEvent:run(connection)
      print("Error: Do not run CTrailerTipAreaEvent locally");
end;
 
function CTrailerTipAreaEvent.runLocally(area, fillType, valueAccumulation)
    
       local groundValueId = g_currentMission.groundValueIds[fillType];
       if groundValueId == nil then
          return nil;
       end;
       local numAreas = table.getn(area);
    
       local refX, refY= area[1],area[2];
       local values = { {x=area[3], y=area[4]}, {x=area[5], y=area[6]} };
  
       local values, bitType = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);
    
       local retArea = nil;
       local x = values[1].x;
       local z = values[1].y;
        local x1 = values[2].x;
        local z1 = values[2].y;
        local x2 = values[3].x;
        local z2 = values[3].y;
       local fillLevel = area[7];
   
      local amount = fillLevel / groundValueId.groundAmountToFillLevel + valueAccumulation;
  
        local addedAmount, _, amountPerPixel, roundingError = Utils.addGroundValueArea(groundValueId.id, groundValueId.firstChannel, groundValueId.numChannels, x, z, x1, z1, x2, z2, amount);
  
        if addedAmount > 0 and amountPerPixel > 0 then
           area[8] = math.min(amountPerPixel, groundValueId.maxValue);
            retArea = area;
        end;
        return retArea, bitType, roundingError;
end;