--
-- wheel_weights
-- Specialization class for wheel_weights
--
-- @author  PeterJ - FS-UK modteam
-- @date  30/09/11
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
  
wheel_weights = {};
 
function wheel_weights.prerequisitesPresent(specializations)
     return true;
end;
 
function wheel_weights:load(xmlFile)

	self.weightLevel = 1;
	self.currentWeight = 0;
	self.weightValue = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.weight#value"), 100);
  	self.setWeightLevel = SpecializationUtil.callSpecializationsFunction("setWeightLevel");

	self.weight1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheelWeights.weight1#index"));
	self.weight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheelWeights.weight2#index"));

	self.weightInRange =  Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.inRange#index"));
	
end;
  
function wheel_weights:delete()
end;

function wheel_weights:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local weightLevel = getXMLInt(xmlFile, key.."#weightLevel");
		if weightLevel ~= nil then
			self:setWeightLevel(weightLevel);
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function wheel_weights:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';

	local mystring = 'weightLevel="' .. tonumber(self.weightLevel) ..'"';	
	attributes = attributes .. mystring;

    local node = nil;
	return attributes, node;
end;
function wheel_weights:readStream(streamId, connection)
	self:setWeightLevel(streamReadInt8(streamId), true);
end;
  
function wheel_weights:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.weightLevel);
end;
  
function wheel_weights:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function wheel_weights:keyEvent(unicode, sym, modifier, isDown)
end;
  
function wheel_weights:update(dt)

	if not self:getIsActive() then
		if self.playerInRange then
			g_currentMission:addHelpButtonText(g_i18n:getText("ADD_WHEELWEIGHT"), InputBinding.ADD1);
			g_currentMission:addHelpButtonText(g_i18n:getText("REMOVE_WHEELWEIGHT"), InputBinding.REMOVE1);
			g_currentMission:addExtraPrintText("Front weight: " ..string.format("%d kg", (self.currentWeight/2)));
			if InputBinding.hasEvent(InputBinding.ADD1) then
				self:setWeightLevel(math.abs(self.weightLevel + 1));
			end;
			if InputBinding.hasEvent(InputBinding.REMOVE1) then
				self:setWeightLevel(math.abs(self.weightLevel - 1));
			end;
		end;
	end;

end;
  
function wheel_weights:updateTick(dt)

	if g_currentMission.player ~= nil then
		local nearestDistance = 2.3;
		local x1,y1,z1 = getWorldTranslation(self.weightInRange);
		local x3,y3,z3 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x3,y1-y3,z1-z3);
		if distance < nearestDistance then
			self.playerInRange = true;
		else
			self.playerInRange = false; 
		end;
	end;
	
	if self.emptyMass == nil then
		self.emptyMass = getMass(self.components[1].node);
		self.currentMass = self.emptyMass;
	end;
	local newMass = self.emptyMass + (self.currentWeight / 700);
	if newMass ~= self.currentMass then
		setMass(self.components[1].node, newMass);
		self.currentMass = newMass;
		for k,v in pairs(self.components) do
			if v.node == self.components[1].node then
				if v.centerOfMass ~= nil then
					setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
				end;
				break;
			end;
		end;
	end;
end;

function wheel_weights:draw()

end;

function wheel_weights:onEnter(isControlling)
end;
  
function wheel_weights:onLeave()
	self.weightActive = false;
end;
 
function wheel_weights:setWeightLevel(weightLevel, noEventSend)
	WeightLevelEvent.sendEvent(self, weightLevel, noEventSend);

	self.weightLevel = weightLevel;
	if self.weightLevel == 1 then
		self.currentWeight = 0;
		setVisibility(self.weight1, false);
		setVisibility(self.weight2, false);
	end;
	if self.weightLevel == 2 then
		self.currentWeight = self.weightValue;
		setVisibility(self.weight1, true);
		setVisibility(self.weight2, false);
	end;
	if self.weightLevel == 3 then
		self.currentWeight = (2 * self.weightValue);
		setVisibility(self.weight1, true);
		setVisibility(self.weight2, true);
	end;
	if self.weightLevel < 1 then
		self.weightLevel = 1;
	end;
	if self.weightLevel > 3 then
		self.weightLevel = 3;
	end;
	--print(self.weightLevel);
end;
