--
-- front_weight
-- Specialization class for front_weight
--
-- @author  PeterJ - FS-UK modteam
-- @date  30/09/11
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
  
front_weight = {};
 
function front_weight.prerequisitesPresent(specializations)
     return true;
end;
 
function front_weight:load(xmlFile)

	self.weightLevel = 1;
	self.currentWeight = 0;
	self.weightValue = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.weight#value"), 100);
  	self.setWeightLevel = SpecializationUtil.callSpecializationsFunction("setWeightLevel");

	self.weight1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontWeights.weight1#index"));
	self.weight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontWeights.weight2#index"));
	self.weight3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontWeights.weight3#index"));
	self.weight4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontWeights.weight4#index"));
	self.weight5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontWeights.weight5#index"));

	self.weightInRange =  Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.inRange#index"));
	
end;
  
function front_weight:delete()
end;

function front_weight:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local weightLevel = getXMLInt(xmlFile, key.."#weightLevel");
		if weightLevel ~= nil then
			self:setWeightLevel(weightLevel);
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function front_weight:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';

	local mystring = 'weightLevel="' .. tonumber(self.weightLevel) ..'"';	
	attributes = attributes .. mystring;

    local node = nil;
	return attributes, node;
end;

function front_weight:readStream(streamId, connection)
	self:setWeightLevel(streamReadInt8(streamId), true);
end;
  
function front_weight:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.weightLevel);
end;
  
function front_weight:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function front_weight:keyEvent(unicode, sym, modifier, isDown)
end;
  
function front_weight:update(dt)

	if not self:getIsActive() then
		if self.playerInRange then
			g_currentMission:addHelpButtonText(g_i18n:getText("ADD"), InputBinding.ADD1);
			g_currentMission:addHelpButtonText(g_i18n:getText("REMOVE"), InputBinding.REMOVE1);
			g_currentMission:addExtraPrintText("Front weight: " ..string.format("%d kg", self.currentWeight));
			if InputBinding.hasEvent(InputBinding.ADD1) then
				self:setWeightLevel(math.abs(self.weightLevel + 1));
			end;
			if InputBinding.hasEvent(InputBinding.REMOVE1) then
				self:setWeightLevel(math.abs(self.weightLevel - 1));
			end;
		end;
	end;

end;
  
function front_weight:updateTick(dt)

	if g_currentMission.player ~= nil then
		local nearestDistance = 1.3;
		local x1,y1,z1 = getWorldTranslation(self.weightInRange);
		local x3,y3,z3 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x3,y1-y3,z1-z3);
		if distance < nearestDistance then
			self.playerInRange = true;
		else
			self.playerInRange = false; 
		end;
	end;
	
	if self.emptyMass == nil then
		self.emptyMass = getMass(self.components[2].node);
		self.currentMass = self.emptyMass;
	end;
	local newMass = self.emptyMass + (self.currentWeight / 700);
	if newMass ~= self.currentMass then
		setMass(self.components[2].node, newMass);
		self.currentMass = newMass;
		for k,v in pairs(self.components) do
			if v.node == self.components[2].node then
				if v.centerOfMass ~= nil then
					setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
				end;
				break;
			end;
		end;
	end;
end;

function front_weight:draw()

end;

function front_weight:onEnter(isControlling)
end;
  
function front_weight:onLeave()
	self.weightActive = false;
end;
 
function front_weight:setWeightLevel(weightLevel, noEventSend)
	WeightLevelEvent.sendEvent(self, weightLevel, noEventSend);

	self.weightLevel = weightLevel;
	if self.weightLevel == 1 then
		self.currentWeight = 0;
		setVisibility(self.weight1, false);
		setVisibility(self.weight2, false);
		setVisibility(self.weight3, false);
		setVisibility(self.weight4, false);
		setVisibility(self.weight5, false);
	end;
	if self.weightLevel == 2 then
		self.currentWeight = self.weightValue;
		setVisibility(self.weight1, true);
		setVisibility(self.weight2, false);
		setVisibility(self.weight3, false);
		setVisibility(self.weight4, false);
		setVisibility(self.weight5, false);
	end;
	if self.weightLevel == 3 then
		self.currentWeight = (3 * self.weightValue);
		setVisibility(self.weight1, true);
		setVisibility(self.weight2, true);
		setVisibility(self.weight3, false);
		setVisibility(self.weight4, false);
		setVisibility(self.weight5, false);
	end;
	if self.weightLevel == 4 then
		self.currentWeight = (5 * self.weightValue);
		setVisibility(self.weight1, true);
		setVisibility(self.weight2, true);
		setVisibility(self.weight3, true);
		setVisibility(self.weight4, false);
		setVisibility(self.weight5, false);
	end;
	if self.weightLevel == 5 then
		self.currentWeight = (7 * self.weightValue);
		setVisibility(self.weight1, true);
		setVisibility(self.weight2, true);
		setVisibility(self.weight3, true);
		setVisibility(self.weight4, true);
		setVisibility(self.weight5, false);
	end;
	if self.weightLevel == 6 then
		self.currentWeight = (9 * self.weightValue);
		setVisibility(self.weight1, true);
		setVisibility(self.weight2, true);
		setVisibility(self.weight3, true);
		setVisibility(self.weight4, true);
		setVisibility(self.weight5, true);
	end;
	if self.weightLevel < 1 then
		self.weightLevel = 1;
	end;
	if self.weightLevel > 6 then
		self.weightLevel = 6;
	end;
	--print(self.weightLevel);
end;


WeightLevelEvent = {};
WeightLevelEvent_mt = Class(WeightLevelEvent, Event);

InitEventClass(WeightLevelEvent, "WeightLevelEvent");

function WeightLevelEvent:emptyNew()
    local self = Event:new(WeightLevelEvent_mt);
    self.className="WeightLevelEvent";
    return self;
end;

function WeightLevelEvent:new(vehicle, weightLevel)
    local self = WeightLevelEvent:emptyNew()
    self.vehicle = vehicle;
	self.weightLevel = weightLevel;
    return self;
end;

function WeightLevelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.weightLevel = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function WeightLevelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.weightLevel);	
end;

function WeightLevelEvent:run(connection)
	self.vehicle:setWeightLevel(self.weightLevel, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(WeightLevelEvent:new(self.vehicle, self.weightLevel), nil, connection, self.vehicle);
	end;
end;

function WeightLevelEvent.sendEvent(vehicle, weightLevel, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(WeightLevelEvent:new(vehicle, weightLevel), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(WeightLevelEvent:new(vehicle, weightLevel));
		end;
	end;
end;
