--
-- BuyableTwinWheelsAttacher
-- Specialization for BuyableTwinWheelsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
-- @history:	v1.0 and v2.0 by SFM
--				v2.1 changes by fruktor for Fendt 615 (left and right side, but unspecific HUD-text)
--				v2.2 changes: possibility of selection for different tractor types
--

BuyableTwinWheelsAttacher = {};

function BuyableTwinWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableTwinWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableTwinWheels = {};
	self.buyableTwinWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.buyableTwinWheels.twinWheelsLeft = nil;
	self.buyableTwinWheels.twinWheelsRight = nil;
	self.buyableTwinWheels.wheelsInRange = nil;	

    self.mountableWheels = {};
    local i = 0;
    while true do
        local wheelnamei = string.format("vehicle.wheels.wheel(%d)", i);
		local mountable = {};
        local mountableAxles = getXMLInt(xmlFile, wheelnamei .. "#mountableAxles");
        if mountableAxles == nil then
            break;
        end;
		
		mountable.mountableAxles = mountableAxles;
		mountable.driveNode = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#driveNode"));
		table.insert(self.mountableWheels, mountable);
		i = i + 1;
	end;
end;

function BuyableTwinWheelsAttacher:delete()
	if self.buyableTwinWheels.twinWheels ~= nil then
		self.buyableTwinWheels.twinWheels:disassembleWheels(true);
	end;
end;

function BuyableTwinWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableTwinWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableTwinWheelsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyableTwinWheels;
		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.mounttwinwheels) then
					if wheels.twinWheelsLeft == nil and string.match(wheels.wheelsInRange.side, "left") then
						wheels.wheelsInRange:assembleWheels(self);
					elseif wheels.twinWheelsRight == nil and string.match(wheels.wheelsInRange.side, "right") then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.twinWheelsUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableTwinWheelsAttacher:draw()
	local wheels = self.buyableTwinWheels;
	if wheels.wheelsInRange ~= nil then
		g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_text"), InputBinding.mounttwinwheels);
		g_currentMission:addWarning(self.buyableTwinWheels.checkVersion, 0.015, 0.030);
		
		_=[[if wheels.twinWheelsLeft ~= nil or self.twinWheelRight ~= nil then
			--if wheels.wheelsInRange.twinWheelsUser == self then
			
			--if wheels.twinWheelsLeft ~= nil and wheels.wheelsInRange.twinWheelsUser == self then
			if wheels.wheelsInRange.twinWheelsUser == self then
				
			--elseif wheels.twinWheelsRight ~= nil and wheels.wheelsInRange.twinWheelsUser == self then
				--g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.mounttwinwheels);
			end;
		else
			if wheels.wheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.mounttwinwheels);
			end;
		end;]]
	end;
end;

function BuyableTwinWheelsAttacher:onAssembling(buyableTwinWheels)
	--self.buyableTwinWheels.twinWheels = buyableTwinWheels;
	if string.match("right", buyableTwinWheels.side) then
		self.buyableTwinWheels.twinWheelsRight = buyableTwinWheels;
		self.realTyreGripFx         = self.realTyreGripFx         + 0.1;
		self.realVehicleFlotationFx = self.realVehicleFlotationFx + 0.1;
	else
		self.buyableTwinWheels.twinWheelsLeft = buyableTwinWheels;
		self.realTyreGripFx         = self.realTyreGripFx         + 0.1;
		self.realVehicleFlotationFx = self.realVehicleFlotationFx + 0.1;
	end;
end;

function BuyableTwinWheelsAttacher:onDisassembling()
	--self.buyableTwinWheels.twinWheels = nil;
	if self.buyableTwinWheels.wheelsInRange == self.buyableTwinWheels.twinWheelsRight then
		self.buyableTwinWheels.twinWheelsRight = nil;
		self.realTyreGripFx         = self.realTyreGripFx         - 0.1;
		self.realVehicleFlotationFx = self.realVehicleFlotationFx - 0.1;
	elseif self.buyableTwinWheels.wheelsInRange == self.buyableTwinWheels.twinWheelsLeft then
		self.buyableTwinWheels.twinWheelsLeft = nil;
		self.realTyreGripFx         = self.realTyreGripFx         - 0.1;
		self.realVehicleFlotationFx = self.realVehicleFlotationFx - 0.1;
	end;	
end;
