--
-- adjustabelSpeedCutter
-- Implementation of reel and roll speeds
--
-- @author  Knagsted
-- @date  16/7/10
--
-- Do not edit without my permission
--

adjustabelSpeedCutter = {};

function adjustabelSpeedCutter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function adjustabelSpeedCutter:load(xmlFile)
	self.myReelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myReel#index"));
    self.myRollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myRoll#index"));
	self.myKnivesNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myKnives#index"));
	local indexSpikesStr = getXMLString(xmlFile, "vehicle.myReelspikes#index");
    self.spikesCount = getXMLInt(xmlFile, "vehicle.myReelspikes#count");
    self.spikesRootNode = Utils.indexToObject(self.components, indexSpikesStr);
	self.sideArmFwdTranslator = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sideArmFwdTranslator#index"));
	self.sideArmHydraulics1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sideArmHydraulics1#index"));
	self.sideArmHydraulics2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sideArmHydraulics2#index"));
	self.sideArmHydraulicsPush1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sideArmHydraulicsPush1#index"));
	self.sideArmHydraulicsPush2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sideArmHydraulicsPush2#index"));
	self.hydraulicsRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicsRefNode#index")); 
	
	self.myKnivesMaxDisplacement = 0.04;
	self.myKnivesMinDisplacement = -0.04;
	self.myKnivesDisplacement = 0.005;
	
	self.myRollSpeed = 0;
	self.myReelSpeed = 0;
	self.cutterOn = false;
	self.knivesDirection = true;
	self.sideArmAdjustMode = 0;
end;

function adjustabelSpeedCutter:delete()
end;

function adjustabelSpeedCutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function adjustabelSpeedCutter:keyEvent(unicode, sym, modifier, isDown)
end;

function adjustabelSpeedCutter:update(dt)

	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isMotorStarted then

			if self.reelStarted or self.attacherVehicle.timeoutCutterShutdown then
				if self.myRollNode ~= nil then
					rotate(self.myRollNode, self.myRollSpeed, 0, 0);
				end;

				if self.myReelNode ~= nil then
					rotate(self.myReelNode, self.myReelSpeed, 0, 0);
					--correct spikes, so that they always look down
					atx, aty, atz = getRotation(self.myReelNode);
					
					for i=1, self.spikesCount do
						local spike = getChildAt(self.spikesRootNode, i-1);
						tx, ty, tz = getRotation(spike);
						setRotation(spike, -atx, aty, atz);
					end;
				end;
				
				if self.myKnivesNode ~= nil then
					local x,y,z = getTranslation(self.myKnivesNode);
					local displacement = x;
					if displacement >= self.myKnivesMaxDisplacement then
						self.knivesDirection = false;
					elseif displacement <= self.myKnivesMinDisplacement then
						self.knivesDirection = true;
					end;
					
					if self.knivesDirection then
						displacement = x-(self.myKnivesDisplacement * self.myRollSpeed*10);
					else
						displacement = x+(self.myKnivesDisplacement * self.myRollSpeed*10);
					end;
					--renderText(0.5, 0.9, 0.040, displacement);
					
					setTranslation(self.myKnivesNode, displacement,y,z)
				end;
			end;
			
			--Side arm hydraulics adjusting
			local x2,y2,z2 = getRotation(self.sideArm);
			--local hydRot = ((x2 + Utils.degToRad(25)) / 2.72) + Utils.degToRad(0.5);
			
			if 	self.hydraulicsRefNode ~= nil then
				local ax, ay, az = getWorldTranslation(self.sideArmHydraulics1);
				local bx, by, bz = getWorldTranslation(self.hydraulicsRefNode);

				local x, y, z = worldDirectionToLocal(getParent(self.sideArmHydraulics1), bx-ax, by-ay, bz-az);
				setDirection(self.sideArmHydraulics1, x, y, z, 0, 1, 0);
				
				local x3,y3,z3 = getRotation(self.sideArmHydraulics1);
				setRotation(self.sideArmHydraulics1,Utils.degToRad(90)+x3,0,0);
				setRotation(self.sideArmHydraulics2,Utils.degToRad(90)+x3,0,0);
			end;
			
			if self.sideArmHydraulicsPush1 ~= nil and x2 <= Utils.degToRad(15) and x2 >= Utils.degToRad(-25) then
				local x,y,z = getTranslation(self.sideArmHydraulicsPush1);
				setTranslation(self.sideArmHydraulicsPush1, x, y + (0.00205 * self.sideArmAdjustMode), z);
			end;
			
			if self.sideArmHydraulicsPush2 ~= nil and x2 <= Utils.degToRad(15) and x2 >= Utils.degToRad(-25) then
				local x,y,z = getTranslation(self.sideArmHydraulicsPush2);
				setTranslation(self.sideArmHydraulicsPush2, x, y + (0.00205 * self.sideArmAdjustMode), z);
			end;
		end;
	end;
end;

function adjustabelSpeedCutter:draw()
end;

