--
-- adjustabelAPWidth
-- Implementation of adjustable AP width so two combines can drive in paralell with helper initiated
--
-- @author  Knagsted
-- @date  1/9/10
--
-- Do not edit without my permission
--

adjustabelAPWidth = {};

function adjustabelAPWidth.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function adjustabelAPWidth:load(xmlFile)
	self.apStart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index"));
    self.apWidth = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index"));
	
	self.width = 0;
	self.orgWidth = 0;
	
	if self.apStart ~= nil then
		local x,y,z = getTranslation(self.apStart);
		self.width = x;
		self.orgWidth = x;
	end;
	
	self.supportsAdjustableWidth = true;
	self.isMyAttacherFormationLeader = false;
	self.formationLeader = nil;
	self.lastTormationLeader = nil;
	self.allignedToLeader = false;
end;

function adjustabelAPWidth:delete()
end;

function adjustabelAPWidth:mouseEvent(posX, posY, isDown, isUp, button)
end;

function adjustabelAPWidth:keyEvent(unicode, sym, modifier, isDown)
end;

function adjustabelAPWidth:update(dt)
	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isEntered then
			if InputBinding.hasEvent(InputBinding.APWIDTHINCREASE) then
				--self.width = self.width - 0.0006 * dt;
				self.width = self.width + self.orgWidth;
				if self.width < self.orgWidth * 4 then
					 self.width = self.orgWidth * 4;
				end;
			end;

			if InputBinding.hasEvent(InputBinding.APWIDTHDECREASE) then
				--self.width = self.width + 0.0006 * dt;
				self.width = self.width - self.orgWidth;
				if self.width > self.orgWidth then
					 self.width = self.orgWidth;
					 self.formationLeader = nil;
				end;
			end;
			
			if self.apStart ~= nil then
				local x,y,z = getTranslation(self.apStart);
				setTranslation(self.apStart, self.width, y, z);
			end;
			
			if self.apWidth ~= nil then
				local x,y,z = getTranslation(self.apWidth);
				setTranslation(self.apWidth, -1*self.width, y, z);
			end;
		end;
		
		if self.attacherVehicle.isAIThreshing and self.width < self.orgWidth then
			--self.attacherVehicle.turnStage3Timeout = 0;
			self.attacherVehicle.turnStage2Timeout = 0;
		else
			if self.attacherVehicle.isAIThreshing ~= nil then
				--self.attacherVehicle.turnStage3Timeout = 10000;
				self.attacherVehicle.turnStage2Timeout = 20000;
			end; 	
		end;

	

		for i=1, table.getn(g_currentMission.attachables) do
			local attachable = g_currentMission.attachables[i];	
			if attachable.supportsAdjustableWidth and attachable.attacherVehicle ~= nil then
				if attachable.attacherVehicle.isAIThreshing and attachable.width < attachable.orgWidth and attachable.formationLeader ~= nil then
					self.formationLeader = attachable.attacherVehicle;
					break;
				end;
			end;
		end;
		
		if self.formationLeader == nil and self.width < self.orgWidth and self.attacherVehicle.isAIThreshing then
			self.formationLeader = self;
		end;
		
		--Now if the formationleader is not our attacherVehicle we set our attacherVehicles AIdirectins to the formation leaders
		if 	self.formationLeader ~= nil and self.formationLeader ~= self.attacherVehicle and self.width < self.orgWidth then
			if self.formationLeader.aiThreshingDirectionX ~= nil and self.attacherVehicle.turnStage == 0 and self.formationLeader.turnStage == 0 and not self.allignedToLeader then
				self.attacherVehicle.aiThreshingDirectionX = self.formationLeader.aiThreshingDirectionX;
				self.attacherVehicle.aiThreshingDirectionZ = self.formationLeader.aiThreshingDirectionZ;
				self.allignedToLeader = true;
				if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered and self.attacherVehicle.HUDActive then
					setTextBold(true);
					renderText(0.01, 0.40, 0.016, string.format("Adjusting allignment to formation leader"));
				end;
			end;
			if self.attacherVehicle.isEntered and self.attacherVehicle.isAIThreshing then
				if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered and self.attacherVehicle.HUDActive then
					setTextBold(true);
					renderText(0.01, 0.38, 0.016, string.format("Following formation"));
				end;
			end;
		elseif self.formationLeader ~= nil and self.width < self.orgWidth then
			if self.attacherVehicle.isEntered then
				if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered and self.attacherVehicle.HUDActive then
					setTextBold(true);
					renderText(0.01, 0.38, 0.016, string.format("Leading formation"));
				end;
			end;
			self.allignedToLeader = false;
		end;
		
		if self.lastFormationLeader ~= self.formationLeader then
			self.allignedToLeader = false;
		end;
		
		if not self.attacherVehicle.isAIThreshing and self.formationLeader == self.attacherVehicle then
			for i=1, table.getn(g_currentMission.attachables) do
				local attachable = g_currentMission.attachables[i];	
				if attachable.supportsAdjustableWidth then
					attachable.formationLeader = nil;
					attachable.allignedToLeader = false;
				end;
			end;
			if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered and self.attacherVehicle.HUDActive then
				setTextBold(true);
				renderText(0.01, 0.42, 0.016, string.format("Resetting formation"));
			end;
		end;
		
		self.lastFormationLeader = self.formationLeader;
	else
		self.formationLeader = nil;
		self.allignedToLeader = false;
	end;
end;

function adjustabelAPWidth:draw()	
		
		if  self.width < self.orgWidth then
			local x, y, z = getRotation(self.attacherVehicle.components[1].node);
			--local length = Utils.vector2Length(x,z);
			--self.threshingDirectionX = x/length;
			--self.threshingDirectionZ = z/length;
			
			--renderText(0.01, 0.4, 0.016, string.format("%.2f", (self.threshingDirectionX) * 180/3.14));
			--renderText(0.01, 0.38, 0.016, string.format("Rotation: " .."%.2f", y * 180/3.14));
		end;	
end;

