--
-- twoAttacherJoints
-- Specialization for twoAttacherJoints
--
-- @author  PeterJ - euroDZN
-- @date  06/06/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

twoAttacherJoints = {};

function twoAttacherJoints.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function twoAttacherJoints:load(xmlFile)
	
	self.getJointTypeInRange = SpecializationUtil.callSpecializationsFunction("getJointTypeInRange");
	
	self.attacherJointNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint.secondAttacher#index"));
	if self.attacherJointNode2 ~= nil then
		self.jointTypeStr2 = getXMLString(xmlFile, "vehicle.attacherJoint.secondAttacher#jointType")
		if self.jointTypeStr2 ~= nil then
			self.jointType2 = Vehicle.jointTypeNameToInt[self.jointTypeStr2];
			if self.jointType2 == nil then
				print("Warning: invalid jointType " .. jointTypeStr2);
			end;
			self.attacherJointFrame1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint#frame"));
			self.attacherJointFrame2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint.secondAttacher#frame"));
			if self.attacherJointFrame1 ~= nil and self.attacherJointFrame2 ~= nil then
				setVisibility(self.attacherJointFrame1, true);
				setVisibility(self.attacherJointFrame2, false);
			end;
			self.jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint#jointType")
			self.jointType = Vehicle.jointTypeNameToInt[self.jointTypeStr];
			self.attacherJointNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint#index"));
		end;
	end;
	
end;

function twoAttacherJoints:delete()
end;
  
function twoAttacherJoints:readStream(streamId, connection)
end;

function twoAttacherJoints:writeStream(streamId, connection)
end;

function twoAttacherJoints:mouseEvent(posX, posY, isDown, isUp, button)
end;

function twoAttacherJoints:keyEvent(unicode, sym, modifier, isDown)
end;

function twoAttacherJoints:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local secondJointType = getXMLBool(xmlFile, key.."#secondJoint");
		if secondJointType ~= nil then
			if secondJointType then
				if self.attacherJoint.jointType == self.jointType then
					self.attacherJoint.node = self.attacherJointNode2;
					self.attacherJoint.jointType = self.jointType2;
					self.secondJointType = true;
					setVisibility(self.attacherJointFrame1, not self.secondJointType);
					setVisibility(self.attacherJointFrame2, self.secondJointType);
				end;
			end;
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function twoAttacherJoints:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'secondJoint="'..tostring(self.secondJointType)..'"';
	return attributes, nil;
end;

function twoAttacherJoints:update(dt)
	if not self:getIsActive() then
		if not self.implementMounted then
			self:getJointTypeInRange()
			if self.secondJointType then
				if self.attacherJoint.jointType == self.jointType then
					self.attacherJoint.node = self.attacherJointNode2;
					self.attacherJoint.jointType = self.jointType2;
					setVisibility(self.attacherJointFrame1, not self.secondJointType);
					setVisibility(self.attacherJointFrame2, self.secondJointType);
				end;
			else
				if self.attacherJoint.jointType == self.jointType2 then
					self.attacherJoint.node = self.attacherJointNode;
					self.attacherJoint.jointType = self.jointType;
					setVisibility(self.attacherJointFrame1, not self.secondJointType);
					setVisibility(self.attacherJointFrame2, self.secondJointType);
				end;
			end;
		end;
	end;
end;

function twoAttacherJoints:updateTick(dt)
end;

function twoAttacherJoints:draw()
end;

function twoAttacherJoints:onAttach()
	self.implementMounted = true;
end; 	

function twoAttacherJoints:onDetach()
	self.implementMounted = false;
end;

function twoAttacherJoints:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 then
		self.flipTipSide = false;
	else
		self.flipTipSide = true;
	end;
end;

function twoAttacherJoints:getJointTypeInRange()
	local jointDistance = 0.95;
	local px, py, pz = getWorldTranslation(self.attacherJointNode);
	for k,v in pairs(g_currentMission.steerables) do
		if v.attacherJoints ~= nil then
			local dx, dy, dz = getWorldTranslation(v.components[1].node);
			local vehicleDist = Utils.vector3Length(px-dx, py-dy, pz-dz);
			if vehicleDist < 4 then
				for _, jointNode in pairs(v.attacherJoints) do
					if jointNode.jointTransform ~= nil then
						if jointNode.jointType == self.jointType then
							self.secondJointType = false;
							break;
						elseif jointNode.jointType == self.jointType2 then
							local tx, ty, tz = getWorldTranslation(jointNode.jointTransform);
							local distance = Utils.vector3Length(px-tx, py-ty, pz-tz);
							if distance < jointDistance then
								self.secondJointType = true;
							end;
						end;
					end;
				end;
			end;
		end;
    end;
end;

function twoAttacherJoints:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;