--@Author: Alex2009, Sven777b
--@Web: www.ls-landtechnik.de, www.alex2009.de

waterTankPlaceable = {};
waterTankPlaceable_mt = Class(waterTankPlaceable, Placeable);
InitObjectClass(waterTankPlaceable, "waterTankPlaceable");

function waterTankPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, waterTankPlaceable_mt);
    registerObjectClassName(self, "waterTankPlaceable");
    return self;
end;

function waterTankPlaceable:delete()
    removeTrigger(self.WaterTrailerFillTriggerId);
    unregisterObjectClassName(self);
    waterTankPlaceable:superClass().delete(self);
end;

function waterTankPlaceable:deleteFinal()
    waterTankPlaceable:superClass().deleteFinal(self);
end;

function waterTankPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not waterTankPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.WaterTrailerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.FillTrigger#index"));
    WaterTrailerFillTrigger:onCreate(self.WaterTrailerFillTriggerId);
    delete(xmlFile);
    return true;
end;

function waterTankPlaceable:update(dt)
end;
registerPlaceableType("waterTankPlaceable", waterTankPlaceable);