--
-- @team    Freelance Modding Crew (FMC)
-- @author  Decker_MMIV - fs-uk.com, forum.farming-simulator.com, modhoster.com
-- @date    2012-11-28
--

--
SprayerWithPTO = {}

function SprayerWithPTO.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations)
       and SpecializationUtil.hasSpecialization(ImplementLinks, specializations);
end;

function SprayerWithPTO:load(xmlFile)
    Sprayer.load(self, xmlFile);
    --
    self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
    self.saveMinRpm = 0; 
    self.printWarningTime = 0;
end;

function SprayerWithPTO:delete()
    Sprayer.delete(self);
end;

function SprayerWithPTO:readStream(streamId, connection)
    Sprayer.readStream(self, streamId, connection);
end;

function SprayerWithPTO:writeStream(streamId, connection)
    Sprayer.writeStream(self, streamId, connection);
end;

function SprayerWithPTO:readUpdateStream(streamId, timestamp, connection)
    Sprayer.readUpdateStream(self, streamId, timestamp, connection);
end;

function SprayerWithPTO:writeUpdateStream(streamId, connection, dirtyMask)
    Sprayer.writeUpdateStream(self, streamId, connection, dirtyMask)
end;

function SprayerWithPTO:mouseEvent(posX, posY, isDown, isUp, button)
    Sprayer.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SprayerWithPTO:keyEvent(unicode, sym, modifier, isDown)
    Sprayer.keyEvent(self, unicode, sym, modifier, isDown);
end;
  
function SprayerWithPTO:update(dt)
    if self.isClient and self:getIsActiveForInput() then
        if self.PTOId then
            -- PTO is detached, so not able to turn-on sprayer
            if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) then
                self.printWarningTime = self.time + 1500;
            end;
        else
            -- PTO is attached.
            if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and self.attacherVehicle.isMotorStarted then
                self:setIsTurnedOn(not self.isTurnedOn);
            end;
        end;
    end;
    --
    --Sprayer.update(self, dt);
end;

function SprayerWithPTO:updateTick(dt)
    if self.isClient then
        if self.PTOId or not self.attacherVehicle.isMotorStarted then
            -- PTO is detached, or engine is off.
            self:setIsTurnedOn(false);
        end;
        self:setVehicleRpmUp(dt, self.isTurnedOn);
    end;
    --
    Sprayer.updateTick(self, dt);
end;

function SprayerWithPTO:draw()
    if self.isClient then
        if self.printWarningTime > self.time then
            g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
        end;
        if self.PTOId then
            -- Hmm. Okay, so unable to hide the "Turn on" help-text, unless going to copy entire code from base Sprayer.draw() function.
        end;
    end;
    --
    Sprayer.draw(self);
end;

function SprayerWithPTO:onDetach()
    --self.attacherVehicle.motor.minRpm = self.saveMinRpm;
    --
    Sprayer.onDetach(self);
    --
    for k, steerable in pairs(g_currentMission.steerables) do
        if self.attacherVehicleCopy == steerable then
            steerable.motor.minRpm = self.saveMinRpm;
            self.attacherVehicleCopy = nil;
        end;
    end;
end;

function SprayerWithPTO:onAttach(attacherVehicle)
    --Sprayer.onAttach(self, attacherVehicle);
    Attachable.onAttach(self, attacherVehicle);
    --
    if self.attacherVehicleCopy == nil then
        self.attacherVehicleCopy = self.attacherVehicle;
    end;
    self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function SprayerWithPTO:onLeave()
    Sprayer.onLeave(self);
end;

function SprayerWithPTO:onDeactivate()
    Sprayer.onDeactivate(self);
end;

function SprayerWithPTO:onDeactivateSounds()
    Sprayer.onDeactivateSounds(self);
end;

function SprayerWithPTO:getIsTurnedOnAllowed(isTurnedOn)
    return Sprayer.getIsTurnedOnAllowed(self, isTurnedOn);
end;

function SprayerWithPTO:setIsTurnedOn(isTurnedOn, noEventSend)
    Sprayer.setIsTurnedOn(self, isTurnedOn, noEventSend);
end;

function SprayerWithPTO:setIsSprayerFilling(isFilling, fillType, isSiloTrigger, noEventSend)
    Sprayer.setIsSprayerFilling(self, isFilling, fillType, isSiloTrigger, noEventSend);
end;

function SprayerWithPTO:addSprayerFillTrigger(trigger)
    Sprayer.addSprayerFillTrigger(self, trigger);
end;

function SprayerWithPTO:removeSprayerFillTrigger(trigger)
    Sprayer.removeSprayerFillTrigger(self, trigger);
end;

--
function SprayerWithPTO:setVehicleRpmUp(dt, isActive)
    if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
        if dt ~= nil then
            if isActive == true then
                self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
            else
                self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
            end;
        else
            self.attacherVehicle.motor.minRpm = self.saveMinRpm;
        end;
        if self.attacherVehicle.isMotorStarted then
            local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
            self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
            g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
            g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
        end;
    end;
end;
