--
-- Bergmann_Shuttle
-- Specialization for Bergmann_Shuttle mod
--
-- @author  Tobias F. (John Deere 6930, 1. LS-Modschmiede)

Bergmann_Shuttle = {};

function Bergmann_Shuttle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Bergmann_Shuttle:load(xmlFile)

	self.drum1= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index1"));
	self.drum2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index2"));
	self.drum3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index3"));
    self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);

	local pickupNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pickup#index"));
    if pickupNode ~= nil then
        self.pickup = {};
        self.pickup.node = pickupNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pickup#minRot"));
        self.pickup.minRot = {};
        self.pickup.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.pickup.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.pickup.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pickup#maxRot"));
        self.pickup.maxRot = {};
        self.pickup.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.pickup.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.pickup.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.pickup.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pickup#rotTime"), 2)*1000;
        self.pickup.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pickup#touchRotLimit"), 10));
    end;


end;



function Bergmann_Shuttle:delete()
end;

function Bergmann_Shuttle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Bergmann_Shuttle:keyEvent(unicode, sym, modifier, isDown)
end;

function Bergmann_Shuttle:update(dt)
	local activeGround = true;

    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.PUdown = not self.PUdown;
        end;
end;

	if self.pickup ~= nil then
		local x, y, z = getRotation(self.pickup.node);
		local minRot = self.pickup.minRot;
		local eps = self.pickup.touchRotLimit;
		if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
			activeGround = false;
		end;
	end;
	if not self.PUdown then
		self.isTurnedOn = false
	else
  		self.isTurnedOn = true;
	end;
	if self.drum1 ~= nil and self.isTurnedOn then
		rotate(self.drum1, self.drumRotationScale * 35 * -3, 0, 0);
	end;

	if self.drum2 ~= nil and activeGround then
		rotate(self.drum2, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection * 3 , 0, 0);
	end;

	if self.drum3 ~= nil and activeGround then
		rotate(self.drum3, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection * 3, 0, 0);
	end;


	if self.pickup ~= nil then
        local x, y, z = getRotation(self.pickup.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.pickup.maxRot, self.pickup.minRot, 3, self.pickup.rotTime, dt, not self.PUdown);
        setRotation(self.pickup.node, unpack(newRot));
    end;
end;

function Bergmann_Shuttle:draw()
end;