
ManureCultivator = {};

function ManureCultivator.prerequisitesPresent(specializations)
print(string.format("\n\t%s\n", "Script Edit by sKyDaNcEr"));
    return true;
end;

function ManureCultivator:load(xmlFile)
	self.MC = true;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sprayCuttingAreas#count"), 0);
    self.sprayCuttingAreas = {}
    for i=1, numCuttingAreas do
        self.sprayCuttingAreas[i] = {};
        local areanamei = string.format("vehicle.sprayCuttingAreas.cuttingArea%d", i);
        self.sprayCuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.sprayCuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.sprayCuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	x,y,z = getTranslation(self.powerShaft.node);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft.node);
	local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
	self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.rohrOptions = nil;
end;

function ManureCultivator:delete()
end;

function ManureCultivator:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManureCultivator:keyEvent(unicode, sym, modifier, isDown)
end;

function ManureCultivator:update(dt)
	if self.attacherVehicle then
		for k,i in pairs(self.attacherVehicle.attachedImplements) do
			local implement = i.object;
			if implement.HF then
				self.rohrOptions = implement.rohrOptions;
				if self.rohrOptions ~= nil then		
					local ax, ay, az = getWorldTranslation(self.powerShaft.node);
					local bx, by, bz = getWorldTranslation(self.rohrOptions);
					local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
					local upx,upy,upz = worldDirectionToLocal(getParent(self.powerShaft.node), 0, -1, 0);
					setDirection(self.powerShaft.node, x, y, z, upx, upy, upz);
					local dx, dy, dz = getWorldTranslation(self.rohrOptions);
					local distance = Utils.vector3Length(dx-ax, dy-ay, dz-az);
					setScale(self.powerShaft.node, 1, 1, distance+self.powerShaft.distance);
				end;
			end;
		end;
	end;
end;
function ManureCultivator:draw()
end;
function ManureCultivator:onDetach()
	setTranslation(self.powerShaft.node, unpack(self.powerShaft.trans));
	setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
end;