﻿HOLMERSLEPP = {};

function HOLMERSLEPP.prerequisitesPresent(specializations)
	print(string.format("\n\t%s\n", "Script Edit by sKyDaNcEr"));
    return true;
end;

function HOLMERSLEPP:load(xmlFile)
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	x,y,z = getTranslation(self.powerShaft.node);
	self.powerShaft.trans = {x,y,z};
	
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft.node);
	local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
	self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.rohrOptions = nil;
	self.open = false;
	self.HS = true;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sprayCuttingAreas#count"), 0);
    self.sprayCuttingAreas = {}
    for i=1, numCuttingAreas do
        self.sprayCuttingAreas[i] = {};
        local areanamei = string.format("vehicle.sprayCuttingAreas.cuttingArea%d", i);
        self.sprayCuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.sprayCuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.sprayCuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	self.sprayValves = {};
	local psFile = getXMLString(xmlFile, "vehicle.sprayParticleSystem#file");
	if psFile ~= nil then
		local i=0;
		while true do
			local baseName = string.format("vehicle.sprayValves.sprayValve(%d)", i);
			local node = getXMLString(xmlFile, baseName.. "#index");
			if node == nil then
				break;
			end;

			node = Utils.indexToObject(self.components, node);
			if node ~= nil then
				local sprayValve = {};
				sprayValve.particleSystems = {};
				Utils.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.sprayParticleSystem", node, false, nil, self.baseDirectory);
				table.insert(self.sprayValves, sprayValve);
			end;
			i = i+1;
		end;
	end;
	self.attacherOptions = {};
	self.attacherOptions.frame = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint#frame"));
	self.attacherOptions.scale = 1;
	self.groundCheck = {};
	self.groundCheck.left = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#left"));
	self.groundCheck.right = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#right"));
	self.levelCheck = false;
	self.attachingFinished = false;
end;

function HOLMERSLEPP:delete()
for k,sprayValve in pairs(self.sprayValves) do
          Utils.deleteParticleSystem(sprayValve.particleSystems);
      end;
end;

function HOLMERSLEPP:readStream(streamId, connection)	
end;

function HOLMERSLEPP:writsream(streamId, connection)
end;

function HOLMERSLEPP:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HOLMERSLEPP:keyEvent(unicode, sym, modifier, isDown)
end;

function HOLMERSLEPP:update(dt)
	if self.animationParts[1].inputDone and self.animationParts[1].clipEndTime then
		self.open = true;
		self.levelCheck = true;
	elseif not self.animationParts[1].clipEndTime then
		self:setAnimationTime(2, self.animationParts[2].startPosition, false);
		self.open = false;
	end;
	if self.attachingFinished then
		local implement = self.attacherVehicle:getImplementByObject(self);
		if implement ~= nil then
			local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
			self.attacherOptions.scale = joint.topArm.zScale;
			setJointFrame(joint.jointIndex, 1, self.attacherJoint.node);
			self.attachingFinished = false;			
		end;		
	end;
	if self.attacherVehicle ~= nil then
		local lx,ly,lz = localDirectionToWorld(self.attacherVehicle.rootNode, 0, 0, 1*self.attacherOptions.scale);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherOptions.frame), lx,ly,lz);
		setDirection(self.attacherOptions.frame, x, y, z, 0, 1, 0);
		for k,i in pairs(self.attacherVehicle.attachedImplements) do
			local implement = i.object;
			if implement.HF then
				self.rohrOptions = implement.rohrOptions;
				if self.rohrOptions ~= nil then		
					local ax, ay, az = getWorldTranslation(self.powerShaft.node);
					local bx, by, bz = getWorldTranslation(self.rohrOptions);
					local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
					local upx,upy,upz = worldDirectionToLocal(getParent(self.powerShaft.node), 0, -1, 0);
					setDirection(self.powerShaft.node, x, y, z, upx, upy, upz);
					local dx, dy, dz = getWorldTranslation(self.rohrOptions);
					local distance = Utils.vector3Length(dx-ax, dy-ay, dz-az);
					setScale(self.powerShaft.node, 1, 1, distance+self.powerShaft.distance);
				end;
			end;
		end;
	end;
	if self.levelCheck then	
		local x,y,z = getWorldTranslation(self.groundCheck.right);
		local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
		local gCr = y-terrainHeight; 
		local x,y,z = getWorldTranslation(self.groundCheck.left);
		local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
		local gCl = y-terrainHeight; 
		local gC = math.floor(math.min(gCl,gCr) * 10) / 10;
		if (gC < 1.0) then 
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
		elseif (gC > 1.0) then 
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
		else
			self:setAnimationTime(2, self.animationParts[2].currentPosition, false);
		end;
	end;
end;

function HOLMERSLEPP:draw()	
end;

function HOLMERSLEPP:onDetach()
	setTranslation(self.powerShaft.node, unpack(self.powerShaft.trans));
	setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
	self.attachingFinished = false;
end;
function HOLMERSLEPP:onAttach()
	self.attachingFinished = true;
end;
