﻿AttacherImplements = {};

function AttacherImplements.prerequisitesPresent(specializations)
	print(string.format("\n\t%s\n", "Script Edit by sKyDaNcEr"));
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function AttacherImplements:load(xmlFile)
	self.allowFillWithArm = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.allowFillWithArm#value"), false);
	if self.allowFillWithArm then
		self.fillArmNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.allowFillWithArm#node"));
	end;
	self.HF = true;
	self.backupCuttingAreas = self.cuttingAreas;
	self.backupsprayValves = self.sprayValves;
	self.rohrOptions = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rohr#rohr"));
	
	self.hudInfoBasePosXh = 0.8;
    self.hudInfoBaseWidthh = 0.2;
    self.hudInfoBasePosYh = 0.63;
    self.hudInfoBaseHeighth = 0.250;
    self.infoPanelPathh = Utils.getFilename("Texturen/fass2.png", self.baseDirectory);
	self.hudInfoBaseOverlayh = Overlay:new("hudInfoBaseOverlay", self.infoPanelPathh, self.hudInfoBasePosXh, self.hudInfoBasePosYh, self.hudInfoBaseWidthh, self.hudInfoBaseHeighth);
    self.showHudInfoBaseh = false;
	self.pumpeon = false;
end;

function AttacherImplements:delete()
	if self.hudInfoBaseOverlayh ~= nil then
		self.hudInfoBaseOverlayh:delete();
	end;   
end;

function AttacherImplements:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AttacherImplements:keyEvent(unicode, sym, modifier, isDown)

end;

function AttacherImplements:update(dt)
	if self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.pumpeon) then
			self.pumpeon = not self.pumpeon;
		end;
		if self.pumpeon then
			if InputBinding.isPressed(InputBinding.saugrohr_UP) and self:getIsActiveForInput() then
				self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
			elseif InputBinding.isPressed(InputBinding.saugrohr_DOWN) and self:getIsActiveForInput() then
				self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
			end;
			if InputBinding.isPressed(InputBinding.saugrohr_left) and self:getIsActiveForInput() then
				self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
			elseif InputBinding.isPressed(InputBinding.saugrohr_right) and self:getIsActiveForInput() then
				self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
			end;	
		end;
	end;

	if self.fillLevel == 0 or self.currentFillType == 0 then
		self:setIsTurnedOn(false, true);
	elseif self.isTurnedOn and self.speedViolationTimer > 0 and self.fillLevel ~= 0 and self.currentFillType ~= 0 then
		local litersPerSecond = self.sprayLitersPerSecond[self.currentFillType];
		if litersPerSecond == nil then
			litersPerSecond = self.defaultSprayLitersPerSecond;
		end;
		local usage =  litersPerSecond  * dt*0.001;
		self:setFillLevel(self.fillLevel - usage, self.currentFillType);
	end; 
	self.holmerschlepp = false;
	self.manureculti = false;
	self.manurecultiobj = nil;
	self.holmerschleppobj = nil;
	if self.attacherVehicle then
		for k,i in pairs(self.attacherVehicle.attachedImplements) do
			local implement = i.object;
			if implement.MC then
				self.manureculti = true;
				self.manurecultiobj = implement;
			elseif implement.HS then 
				self.holmerschlepp = true;
				self.holmerschleppobj = implement;
			end;
		end;
	end;
	if self.manureculti then
		if self.manurecultiobj.sprayCuttingAreas ~= nil then
			self.cuttingAreas = self.manurecultiobj.sprayCuttingAreas;
		elseif self.manurecultiobj.cuttingAreas ~= nil and self.manurecultiobj.sprayCuttingAreas == nil then
			self.cuttingAreas = self.manurecultiobj.cuttingAreas;
		end;
		if self.fillLevel <= 0.0 then
			self.attacherVehicle:stopAITractor()
		end;
		if not self.manurecultiobj:isLowered(false) then
			self:setIsTurnedOn(false, true);
		else
			self:setIsTurnedOn(true, true);
		end;
	elseif self.holmerschlepp	then
		if InputBinding.hasEvent(InputBinding.HOLMERSLEPP_open) and self:getIsActiveForInput() then
			if self.holmerschleppobj.open  then
				if self.holmerschleppobj.levelCheck then
					self.holmerschleppobj.levelCheck = false;
				end;
				self.holmerschleppobj:setAnimationTime(1, self.holmerschleppobj.animationParts[1].offSet, false);
			else
				self.holmerschleppobj:setAnimationTime(1, self.holmerschleppobj.animationParts[1].animDuration, false);
			end;
		end;
		if not self.holmerschleppobj.open and self.isTurnedOn then
			self:setIsTurnedOn(false, true);
		end;
		if self.holmerschleppobj.sprayCuttingAreas ~= nil then
			self.cuttingAreas = self.holmerschleppobj.sprayCuttingAreas;
			self.sprayValves = self.holmerschleppobj.sprayValves
		elseif self.holmerschleppobj.cuttingAreas ~= nil and self.holmerschleppobj.sprayCuttingAreas == nil then
			self.cuttingAreas = self.holmerschleppobj.cuttingAreas;
		end;
	else
		self.cuttingAreas = self.backupCuttingAreas;
		self.sprayValves = self.backupsprayValves;
	end;
		
end;

function AttacherImplements:draw()
	if InputBinding.hasEvent(InputBinding.SHOWhzHUD) then
		self.showHudInfoBaseh = not self.showHudInfoBaseh;
	end;
	local textZ = 0.015;
	if self.showHudInfoBaseh then		
		self.hudInfoBaseOverlayh:render();
		if self.pumpeon then
			renderText(0.8, 0.86, textZ, string.format("%s:\n%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.pumpeon), "Saug Pumpe deactiviren"));
			renderText(0.8, 0.82, textZ, string.format("%s:\n%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.saugrohr_UP), "Saug Rüssel Up"));
			renderText(0.8, 0.78, textZ, string.format("%s:\n%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.saugrohr_DOWN), "Saug Rüssel Down"));
			renderText(0.8, 0.74, textZ, string.format("%s:\n%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.saugrohr_left), "Saug Rüssel rechts"));
			renderText(0.8, 0.70, textZ, string.format("%s:\n%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.saugrohr_right), "Saug Rüssel Links"));
		else
			renderText(0.8, 0.86, textZ, string.format("%s:\n%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.pumpeon), "Saug Pumpe aktiviren"));
			if self.holmerschlepp then

				g_currentMission:addExtraPrintText(string.format("%s: %s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.HOLMERSLEPP_open), "schleb schlauch öfnnen/schlissen"));
				renderText(0.8, 0.82, textZ, string.format("%s:\n%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.HOLMERSLEPP_open), "schleb schlauch öfnnen/schlissen"));
			end;
		end;
		renderText(0.81, 0.25, textZ, string.format("%s - %s", g_i18n:getText("hideInfo"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.SHOWhzHUD)));
	else
		renderText(0.81, 0.25, textZ, string.format("%s - %s", g_i18n:getText("displayInfo"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.SHOWhzHUD)));
	end;
	if self.holmerschlepp then
		g_currentMission:addExtraPrintText(string.format("%s: %s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.HOLMERSLEPP_open), "schleb schlauch öfnnen/schlissen"));
	end
end;