--
-- HollandFarm_Map_V4
--
-- @author  Mike / www.ls-nextgeneration.com
-- @date  15/01/13
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

HollandFarm_Map_V4 = {}

local HollandFarm_Map_V4_mt = Class(HollandFarm_Map_V4, Mission00);


function HollandFarm_Map_V4:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = HollandFarm_Map_V4_mt;
    end;
    local self = HollandFarm_Map_V4:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function HollandFarm_Map_V4:delete()
    HollandFarm_Map_V4:superClass().delete(self);
end;

function HollandFarm_Map_V4:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("HollandFarm_Map_V4.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function HollandFarm_Map_V4:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("HollandFarm_Map_V4.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 - 230, 1024 + 439.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 - 144.65, 1024 - 352.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 + 513.75, 1024 + 202, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 + 723.9, 1024 + 608.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 - 162, 1024 - 679.51, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    --self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 1024 - 130, 1024 - 383, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 + 89.6, 1024 - 417.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 - 603.4, 1024 - 834, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 - 94, 1024 + 20.1, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 - 560, 1024 - 7.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 - 172.25, 1024 - 678.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 + 241.1, 1024 + 438, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 43.5, 1024 - 128.3, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 395.1, 1024 - 693.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 888.8 , 1024 + 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 753.5 , 1024 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 640.4 , 1024 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 692.7 , 1024 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 1024 + 256, 1024 + 655, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 1024 - 600, 1024 + 585, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 1024 - 12, 1024 - 93, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    HollandFarm_Map_V4:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function HollandFarm_Map_V4:onStartMission()
    HollandFarm_Map_V4:superClass().onStartMission(self);
end;

function HollandFarm_Map_V4:mouseEvent(posX, posY, isDown, isUp, button)
    HollandFarm_Map_V4:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function HollandFarm_Map_V4:keyEvent(unicode, sym, modifier, isDown)
    HollandFarm_Map_V4:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function HollandFarm_Map_V4:update(dt)
    HollandFarm_Map_V4:superClass().update(self, dt);
end;

function HollandFarm_Map_V4:draw()
    HollandFarm_Map_V4:superClass().draw(self);
end;