--
-- hydraulicPipes
-- Specialization for hydraulic pipes
--
-- @author  Stefan Maurus	
-- @date  06/08/13

-- Copyright  Stefan Maurus, www.stefanmaurus.de

--[[
	<pipes attached="" deAttached="">
		<bones activ="true" mesh=""/>
	</pipes>
]]

hydraulicPipes = {};

function hydraulicPipes.prerequisitesPresent(specializations)
    return true;
end;

function hydraulicPipes:load(xmlFile)		
    self.deAttachedPipes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipes#deAttached"));
    self.attachedPipes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipes#attached")); 
	setVisibility(self.attachedPipes, false);
	setVisibility(self.deAttachedPipes, true);
	
	self.hasBonesMesh = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.pipes.bones#activ"), false);
	if self.hasBonesMesh then
		self.bonesMesh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipes.bones#mesh"));
		link(getRootNode(),self.bonesMesh);
		setTranslation(self.bonesMesh,0,0,0);
		setRotation(self.bonesMesh,0,0,0);
	end;	
end;

function hydraulicPipes:delete()
	if self.hasBonesMesh then
		delete(self.bonesMesh);
	end;
end;

function hydraulicPipes:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hydraulicPipes:keyEvent(unicode, sym, modifier, isDown)
end;

function hydraulicPipes:update(dt)
end;

function hydraulicPipes:updateTick(dt)
 end;

function hydraulicPipes:onAttach()	
	setVisibility(self.attachedPipes, true);
	setVisibility(self.deAttachedPipes, false);	
end;

function hydraulicPipes:onDetach()	
	setVisibility(self.attachedPipes, false);
	setVisibility(self.deAttachedPipes, true);	
end;

function hydraulicPipes:draw()
end;