--
-- Herlefeld
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Herlefeld = {}

local Herlefeld_mt = Class(Herlefeld, Mission00);


function Herlefeld:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Herlefeld_mt;
    end;
    local self = Herlefeld:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function Herlefeld:delete()
    Herlefeld:superClass().delete(self);
end;

function Herlefeld:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/Herlefeld.i3d", self.baseDirectory), true, self.loadHerlefeldFinished, self);

	self.addAlternativeTippingHeaps = {};
	self.addAlternativeTippingHeaps["file"] = "map/script/AlternativeTipTrigger.xml";
	self.addAlternativeTippingHeaps["dir"] = g_modsDirectory .. "/Herlefeld/";
	end;

function Herlefeld:loadHerlefeldFinished(node, arguments)

		self.terrainDetailAngleNumChannels = 8; -- durch die gewnschte Anzahl Channels ersetzen
		self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("Herlefeld.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;


    -- ATMs
   -- self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -327, -362, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	

    -- Vehicle Shop
   -- self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -317, -353, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
   -- self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 240, -11, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- farm silos
   -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 15, -183, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
  -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 212, -479, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
	-- Grass Heaps
   -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -84.25 , -221.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);    
   
	-- livestock
   -- self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), -48, -135, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
   -- self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 15, -142, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    Herlefeld:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function Herlefeld:onStartMission()
    Herlefeld:superClass().onStartMission(self);
end;

function Herlefeld:mouseEvent(posX, posY, isDown, isUp, button)
    Herlefeld:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Herlefeld:keyEvent(unicode, sym, modifier, isDown)
    Herlefeld:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Herlefeld:update(dt)
    Herlefeld:superClass().update(self, dt);
end;

function Herlefeld:draw()
    Herlefeld:superClass().draw(self);
end;