-- by "Marhu" 
-- v 1.5
-- Date: 11.03.2013
-- Tranke fr CowWaterMod
	
Traenke = {};
Traenke_mt = Class(Traenke, Placeable);
InitObjectClass(Traenke, "Traenke");

function Traenke:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, Traenke_mt);
    registerObjectClassName(self, "Traenke");
	
	return self;
end;

function Traenke:delete()
    if CowWaterMod and CowWaterMod.tipTrigger then
		if CowWaterMod.CurentTraenke and CowWaterMod.CurentTraenke == self then
			setTranslation(CowWaterMod.tipTrigger, 0,0,0);
		end
	end
	unregisterObjectClassName(self);
    Traenke:superClass().delete(self);
end;

function Traenke:deleteFinal()
    Traenke:superClass().deleteFinal(self);
end;

function Traenke:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not Traenke:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
	
	if not moveMode and CowWaterMod then
		local lx,ly,lz = worldToLocal(getParent(CowWaterMod.tipTrigger),x,y,z)
		local wrx,wry,wrz = getWorldRotation(getParent(CowWaterMod.tipTrigger))
		
		if math.abs(wrx) >= 3.14159 and math.abs(wrz) >= 3.14159 then
			ry=ry*-1
		end
		
		setTranslation(CowWaterMod.tipTrigger, lx,ly,lz);
		setRotation(CowWaterMod.tipTrigger, -wrx+rx,-wry+ry,-wrz+rz);
		
		CowWaterMod.CurentTraenke = self
	end
	  
	return true;
end;

function Traenke:update(dt)
end;

registerPlaceableType("Traenke", Traenke);