--
-- Support
-- This is the specialization for Support
--
-- M@D Author  Headshot XXL
-- M@D date 03.10.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

Support = {};

function Support.prerequisitesPresent(specializations)
    return true;
end;

function Support:load(xmlFile)

	local supportRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.supportRot#index"));
    if supportRotNode ~= nil then
        self.supportRot = {};
        self.supportRot.node = supportRotNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.supportRot#minRot"));
        self.supportRot.minRot = {};
        self.supportRot.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.supportRot.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.supportRot.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.supportRot#maxRot"));
        self.supportRot.maxRot = {};
        self.supportRot.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.supportRot.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.supportRot.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.supportRot.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.supportRot#rotTime"), 4)*1000;
    end;
	
	local supportTransNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.supportTrans#index"));
    if supportTransNode ~= nil then
        self.supportTrans = {};
        self.supportTrans.node = supportTransNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.supportTrans#minTrans"));
        self.supportTrans.minRot = {};
        self.supportTrans.minRot[1] = x;
        self.supportTrans.minRot[2] = y;
        self.supportTrans.minRot[3] = z;

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.supportTrans#maxTrans"));
        self.supportTrans.maxRot = {};
        self.supportTrans.maxRot[1] = x;
        self.supportTrans.maxRot[2] = y;
        self.supportTrans.maxRot[3] = z;

        self.supportTrans.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.supportTrans#transTime"), 4)*1000;
    end;
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].punchPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchPoint"));	
		self.hydraulics[i].punchPoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchPoint2"));
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].punchPoint);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;

	self.supportActive = true;
	
end;

function Support:delete()
end;

function Support:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Support:keyEvent(unicode, sym, modifier, isDown)
end;

function Support:update(dt)
	
		if self.supportRot ~= nil then
		local x, y, z = getRotation(self.supportRot.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.supportRot.maxRot, self.supportRot.minRot, 3, self.supportRot.rotTime, dt, self.supportActive);
		setRotation(self.supportRot.node, unpack(newRot));
	end;
	
	if self.supportTrans ~= nil then
		local x, y, z = getTranslation(self.supportTrans.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans.maxRot, self.supportTrans.minRot, 3, self.supportTrans.rotTime, dt, self.supportActive);
		setTranslation(self.supportTrans.node, unpack(newTrans));
	end;

	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].punchPoint2);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);		
		if self.hydraulics[i].punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
		end;
	end;
	
	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
	
end;

function Support:draw()
end;

function Support:onDetach()

	self.supportActive = true;

end;

function Support:onAttach()
	
	self.supportActive = false;

end;
