-- Gregoire

-- @poc@lypse
-- Copyright (C) Ls-Modteam-France, All Rights Reserved. 

Gregoire= {};

function Gregoire.prerequisitesPresent(specializations)
    return true;
end;

function Gregoire:load(xmlFile)
        self.toggleSupport = SpecializationUtil.callSpecializationsFunction("toggleSupport");   
        self.manualSupportAnimation = getXMLString(xmlFile, "vehicle.manualSupport#animationName");
        self.supportRangeIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manualSupport#rangeIndex"));
        self.isInRangeSupport = false;      
        self.girophare = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.girophare#index"));
        self.attacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacher#index"));
        setVisibility(self.girophare, false);   
end;


function Gregoire:delete()
end;

function Gregoire:readStream(streamId, connection)
local isSupportDown = streamReadBool(streamId);
self:toggleSupport(isSupportDown, true);       
end;

function Gregoire:writeStream(streamId, connection)
streamWriteBool(streamId, self.isSupportDown);
end;

function Gregoire:mouseEvent(posX, posY, isDown, isUp, button)   
end;

function Gregoire:keyEvent(unicode, sym, modifier, isDown)     
end;


function Gregoire:update(dt) 
  if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			-- Show warning about the support being down
			if not self.isSupportDown then
				g_currentMission:addWarning(string.format(g_i18n:getText("GREGOIRE_SUPPORT_WARNING")), 0.018, 0.033);
			end;
  end;

       if self.supportRangeIndex then
		-- Manage key events for inrange support --
		if self.isInRangeSupport then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				if self.isSupportDown then
					self:toggleSupport(false);
				else
					self:toggleSupport(true);
				end;
			end;
			-- Display key when in range --
			if not self.isSupportDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("GREGOIRE_RAISE_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("GREGOIRE_LOWER_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
	end;

    setJointFrame(self.componentJoints[8].jointIndex, 0, self.componentJoints[8].jointNode);
    setJointFrame(self.componentJoints[5].jointIndex, 0, self.componentJoints[5].jointNode);
end;

function Gregoire:updateTick(dt)

       if self.supportRangeIndex then
		if g_currentMission.player ~= nil then
			-- Getting the distance between the player and the support
			local nearestDistance = 1.5; --max distance allowed
			local px, py, pz = getWorldTranslation(self.supportRangeIndex);
			local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				self.isInRangeSupport = true;
			else
				self.isInRangeSupport = false;
			end;
		end;
	else
		self.isInRangeSupport = false;
	end;
       
       if self.beaconLightsActive then
          setVisibility(self.girophare, false);   
       else
          setVisibility(self.girophare, true);   
       end   
end;


function Gregoire:draw()
end;

function Gregoire:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local isSupportDown = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isSupportDown"), false);
	self:toggleSupport(isSupportDown);	
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Gregoire:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'isSupportDown="' .. tostring(self.isSupportDown) .. '"';
    return attributes, nil;
end;

function Gregoire:toggleSupport(isSupportDown, noEventSend)
	ToggleSupportEvent.sendEvent(self, isSupportDown, noEventSend);	
	
	if not isSupportDown then
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, -1, nil, true);
		end;
	else
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, 1, nil, true);
		end;
	end;
	
	self.isSupportDown = isSupportDown;
end;

-- Support event

ToggleSupportEvent = {};
ToggleSupportEvent_mt = Class(ToggleSupportEvent, Event);

InitEventClass(ToggleSupportEvent, "ToggleSupportEvent");

function ToggleSupportEvent:emptyNew()
    local self = Event:new(ToggleSupportEvent_mt);
    return self;
end;

function ToggleSupportEvent:new(object, isSupportDown)
    local self = ToggleSupportEvent:emptyNew()
    self.object = object;
	self.isSupportDown = isSupportDown;
    return self;
end;

function ToggleSupportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.isSupportDown = streamReadBool(streamId);
    self:run(connection);
end;

function ToggleSupportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteBool(streamId, self.isSupportDown);
end;

function ToggleSupportEvent:run(connection)
	self.object:toggleSupport(self.isSupportDown, true);
end;

function ToggleSupportEvent.sendEvent(object, isSupportDown, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ToggleSupportEvent:new(object, isSupportDown), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(ToggleSupportEvent:new(object, isSupportDown));
		end;
	end;
end;