--
-- multiFruitModule Standard
--
-- author: upsidedown
-- initial version: 13.01.2014
-- finished V1.0: 13.01.2014
--
-- TO MODDERS WHO WANT TO MAKE THEIR OWN MULTIFRUIT-MODULES:
--
-- please feel free to do so, no extra permission is needed from my side to distribute modules for the Multifruit-Mod V2.0 (or higher)
-- 
-- some things to consider:
-- * fruit substitution is handled within multiFruit_config.xml
-- * multiple packages are possible
-- * if fruits are handled multiple times only the entry first loaded (depends on .zip name, may be different order on dedicated servers!) is inserted by the master mod.
-- * you can add the lua to your map, again no extra permission needed




multiFruitModule_standard = {};
addModEventListener(multiFruitModule_standard);

local modDir = g_currentModDirectory;

function multiFruitModule_standard:loadMap(name)	
	
	-- for int,name in pairs(Fillable.fillTypeIntToName) do
		-- print(tostring(int).."  "..name)
	-- end;
	
	local file = modDir.."scripts/multiFruit_config.xml";
	
	print("--- loading multiFruit Module: "..file.." --- (by upsidedown)")
	
	local newFill = "";
	local subFill = "";
	local subFillCutter = "";
	local subFillSowing = "";
	if g_currentMission.addMultiFruitNewFillTypes == nil then
		g_currentMission.addMultiFruitNewFillTypes = "";
	end;
	
	if g_currentMission.addMultiFruitSubStd == nil then
		g_currentMission.addMultiFruitSubStd = "";
	end;
	
	if g_currentMission.addMultiFruitSubCutter == nil then
		g_currentMission.addMultiFruitSubCutter = "";
	end;
	
	if g_currentMission.addMultiFruitSubSowing == nil then
		g_currentMission.addMultiFruitSubSowing = "";
	end;
	
	
	
	if fileExists(file) then
		xmlFile = loadXMLFile("MF_XML", file, "multiFruit");
		if xmlFile ~= nil then
			
			local i=0;
			while true do
				local areaKey = string.format("multiFruitModule.multiFruits.multiFruit(%d)", i);
				
				if not hasXMLProperty(xmlFile, areaKey) then			
					break;
				end
				
				local new = getXMLString(xmlFile, areaKey .. "#new");
				local subStd = getXMLString(xmlFile, areaKey .. "#subStd");
				local subCutter;
				local subSowing;
				if new ~= nil and subStd ~= nil then					
					subCutter = Utils.getNoNil(getXMLString(xmlFile, areaKey .. "#subCutter"),subStd);
					subSowing = Utils.getNoNil(getXMLString(xmlFile, areaKey .. "#subSowing"),subStd);
					--print(new.."   "..subStd.." "..subCutter.." "..subSowing)
				end;
				
				g_currentMission.addMultiFruitNewFillTypes = g_currentMission.addMultiFruitNewFillTypes .." "..new;
				g_currentMission.addMultiFruitSubStd = g_currentMission.addMultiFruitSubStd .." "..subStd;
				g_currentMission.addMultiFruitSubCutter = g_currentMission.addMultiFruitSubCutter .." "..subCutter;
				g_currentMission.addMultiFruitSubSowing = g_currentMission.addMultiFruitSubSowing .." "..subSowing;
				i = i + 1;
			end

		end;
	else
		print("Error: "..file.." not found!")
	end;
	
	
	
end;

function multiFruitModule_standard:deleteMap()
end


function multiFruitModule_standard:mouseEvent(posX, posY, isDown, isUp, button)
end;

function multiFruitModule_standard:keyEvent(unicode, sym, modifier, isDown)
end;


function multiFruitModule_standard:update(dt)	
end


function multiFruitModule_standard:draw()   
end;
