-- by "Marhu" 
-- v 1.0
-- Date: 14.02.2013
-- Zum Transport von Ballen fr "Map Ballen Frderband"

-- Mapobjekt elevatorMoverTrigger Atribute
-- onCreate --> modOnCreate.MoverTrigger2 (scriptcalback)
-- Load --> [index] (string) Index LoadTrigger
-- Mover --> [index] (string) Index MoverTrigger
-- speed --> [num] (float) [0.5 fast, 10 standart, 100 slow]

-- Map modDesc.xml
--  <extraSourceFiles>
--		<sourceFile filename="map/models/objects/MapBaleConveyor/BarnMoverTrigger2.lua" />
--	</extraSourceFiles>   
   
BarnMoverTrigger2 = {};

local BarnMoverTrigger2_mt = Class(BarnMoverTrigger2);

function BarnMoverTrigger2.onCreate(id)
	g_currentMission:addUpdateable(BarnMoverTrigger2:new(id));
	-- print("created barn mover trigger2, id: ", id);
end;

function BarnMoverTrigger2:new(id, customMt)
  
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, BarnMoverTrigger2_mt);
	end;

  	local LoadIndex = getUserAttribute(id, "Load");
    if LoadIndex ~= nil then
        local LoadId = Utils.indexToObject(id, LoadIndex);
		if LoadId ~= nil then
			instance.LoadTriggerId = LoadId;
			if g_currentMission:getIsServer() then
				addTrigger(instance.LoadTriggerId, "LoadTriggerCallback", instance);
			end;
		end
	end
		  
	local MoverIndex = getUserAttribute(id, "Mover");
	if MoverIndex ~= nil then
		local MoverId = Utils.indexToObject(id, MoverIndex);
		if MoverId ~= nil then
			instance.triggerId = MoverId;
			if g_currentMission:getIsServer() then
				addTrigger(instance.triggerId, "triggerCallback", instance);
			end;
			if instance.LoadTriggerId then
				instance.BalePos = getChildAt(MoverId, 0);
			end
			instance.dirLength = 0.08;
			instance.dirX, instance.dirY, instance.dirZ = localDirectionToWorld(instance.triggerId, 0, 0, 1);
			instance.dirX = instance.dirX*instance.dirLength;
			instance.dirY = instance.dirY*instance.dirLength;
			instance.dirZ = instance.dirZ*instance.dirLength;
			instance.targetVelocity = 2;
		end;
	end;
 	  
	instance.speed =  Utils.getNoNil(getUserAttribute(id, "speed"),10);
	instance.touched = {};
	instance.loadet= {};
   
    return instance;
end;
  
function BarnMoverTrigger2:delete()
  
    if g_currentMission:getIsServer() then
        removeTrigger(self.triggerId);
		if self.LoadTriggerId then
			removeTrigger(self.LoadTriggerId);
		end
    end;
        
end;
  
function BarnMoverTrigger2:update(dt)
  
	local posefree = true
    for k,touched in pairs(self.touched) do
		local t = dt/self.speed
		setLinearVelocity(k, self.dirX*t, self.dirY*t, self.dirZ*t);
		local nearestDistance = 3;
		if self.BalePos then
			local x, y, z = getWorldTranslation(self.BalePos);
			local bx, by, bz = getWorldTranslation(k);
			local distance = Utils.vector3Length(x-bx, y-by, z-bz);
			if distance < nearestDistance then
				posefree = false
			end
		else
			posefree = false
		end
	end;
	
	if posefree and self.LoadTriggerId then
		for k,loadet in pairs(self.loadet) do
			local x, y, z = getWorldTranslation(self.BalePos);
			local rx,ry,rz = getWorldRotation(self.BalePos);
			setTranslation(k,x,y,z );
			setRotation(k, rx,ry,rz);
			break
		end
	end
  
end;
  
function BarnMoverTrigger2:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
	if onEnter then
		local touched = self.touched[otherId];
		if touched ~= nil then
			touched.count = touched.count+1;
		else
			local mass = getMass(otherId);
			self.touched[otherId] = {mass=mass, count=1};
		end;
	elseif onLeave then
		local touched = self.touched[otherId];
		if touched ~= nil then
			if touched.count > 1 then
				touched.count = touched.count-1;
			else
				self.touched[otherId] = nil;
			end;
		end;
	end;
end;

function BarnMoverTrigger2:LoadTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
    if onEnter then
		local loadet = self.loadet[otherId];
		if loadet ~= nil then
			loadet.count = loadet.count+1;
		else
			local mass = getMass(otherId);
			self.loadet[otherId] = {mass=mass, count=1};
		end;
    elseif onLeave then
		local loadet = self.loadet[otherId];
        if loadet ~= nil then
            if loadet.count > 1 then
                loadet.count = loadet.count-1;
            else
                self.loadet[otherId] = nil;
            end;
        end;
    end;
  
end;
   
g_onCreateUtil.addOnCreateFunction("MoverTrigger2", BarnMoverTrigger2.onCreate);
 