--
-- SampleModMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
FruitUtil.registerFruitType("sunflower", g_i18n:getText("sunflower"), true, true, false, 0, 4, 6, 8, true, 0.4, 1.2, 0.05, true, Utils.getFilename("huds/sunflowerHud.dds", baseDirectory), {0,1,0,1});
FruitUtil.registerFruitType("soybean", g_i18n:getText("soybean"), true, true, false, 0, 4, 6, 8, true, 1.1, 0.4, 0.18, true, Utils.getFilename("huds/soybeanHud.dds", baseDirectory), {0.808,0.937,0.741,1});
FruitUtil.registerFruitType("luzerne", g_i18n:getText("luzerne"), true, true, false, 0,	4, 6, 8, false, 0, 0, 0.02,	true, Utils.getFilename("huds/luzerneHud.dds", baseDirectory), {1, 0, 1, 1});
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_SOYBEAN, "barley_windrow", g_i18n:getText("straw"), 0.04, 3, false, "dataS2/missions/hud_fill_straw.png");
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_LUZERNE, "luzerne_windrow", g_i18n:getText("luzerne_windrow"), 0.04, 2.5, true );

	local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = -304.88397;
--    self.playerStartY = 125.16399;
--    self.playerStartZ = -51.4045;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);
	
	--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.setup_map_new ~= nil then
        --fmcSoilMod.setup_map_new(baseDirectory .. "map/fmcSoilManagement/filltypeOverlays")  -- If map provides its own fill-type HUD overlay icons.
        fmcSoilMod.setup_map_new() -- If using icons included with the SoilManagement.ZIP mod.
    end
    --## SoilMod - End ############################################################
    --#############################################################################

    return self;
end;

function SampleModMap:delete()
	--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.teardown_map_delete ~= nil then
        fmcSoilMod.teardown_map_delete()
    end
    --## SoilMod - End ############################################################
    --#############################################################################
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("SampleModMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 907, 230, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 248, -954, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 209, -331, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 + 723.9, 1024 + 608.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 - 162, 1024 - 679.51, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 204, -337, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -603, -834, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -427, -36, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -713, 909, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 237, -954, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -949, 558, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 + 241.1, 1024 + 438, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), 214, -982, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -266, 938, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -393, 60, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -750, -263, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 888.8 , 1024 + 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 753.5 , 1024 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 640.4 , 1024 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 692.7 , 1024 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), -303, 274, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -550, 356, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), -320, -80, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), -916, 540, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;
	
	--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.postInit_loadMapFinished ~= nil then
        if fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected ~= nil then
            -- If needed, set up this map's custom fruit-types fertilizer-boost and herbicide-affected attributes.
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("sunflower"  ,"fertilizer"   ,"herbicide3")
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("soybean"    ,"fertilizer2"  ,"herbicide" )
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("luzerne"    ,"fertilizer3"  ,"herbicide2")
        end
        --
        if fmcSoilMod.setMapProperty ~= nil then
            -- Some of SoilMod's map-properties can be overwritten by the map-mod itself.
        
            -- <<Examples>>
            -- fmcSoilMod.setMapProperty("reduceWindrows",          false) -- (boolean) If windrows/swath should be reduced by 1 height-level during growth-cycle
            -- fmcSoilMod.setMapProperty("removeSprayMoisture",     true)  -- (boolean) If spray-moisture should be removed (vaporised) during growth-cycle
            -- fmcSoilMod.setMapProperty("disableWithering",        true)  -- (boolean) If crop withering should be disabled
            -- fmcSoilMod.setMapProperty("delayGrowthCycle#days",   2)     -- (integer) How many in-game days to skip before activating growth-cycle again
            -- fmcSoilMod.setMapProperty("startGrowthCycle#hour",   6)     -- (integer) At what hour of the in-game day should the growth-cycle start
        end
        --
        fmcSoilMod.postInit_loadMapFinished()
    end
    --## SoilMod - End ############################################################
    --#############################################################################

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
	 --#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.update ~= nil then
        fmcSoilMod.update(dt)
    end
    --## SoilMod - End ############################################################
    --#############################################################################
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
	--#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.draw ~= nil then
        fmcSoilMod.draw()
    end
    --## SoilMod - End ############################################################
    --#############################################################################
end;