--
-- JohnDeere864
-- Orignal: Specialization for New Holland BB 980 from Strawmod
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		21/11/10
--
-- @edit		JoXXer
-- @version		v1.1
-- @date		05/05/11
--

JohnDeere864 = {};

function JohnDeere864.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function JohnDeere864:load(xmlFile)
	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, JohnDeere864.getIsAreaActive);
	self.setPickup= SpecializationUtil.callSpecializationsFunction("setPickup");
	self.setTransport= SpecializationUtil.callSpecializationsFunction("setTransport");

	-- Animations --
	self.PickupAnimation = getXMLString(xmlFile, "vehicle.Pickup#animationName");
	self.Pickup = false;

	-- Animated objects --
	self.numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, self.numRotParts do
        local RotPartsnamei = string.format("vehicle.RotParts.RotPart" .. "%d", i);
        self.RotParts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, RotPartsnamei .. "#index"));
    end;
	self.PickupWheel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PickupWheel1#index"));
	self.PickupWheel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PickupWheel2#index"));
	self.FeederRoll = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FeederRoll#index"));

	-- Transport --
	self.Transport = false;

	-- Transport Objects --

	self.wheelsInTransportPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheelsInTransportPosition#index"));
	self.wheelsInFieldPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheelsInFieldPosition#index"));

	-- Particles --
	self.PickUpParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.PickUpParticleSystems.PickUpParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
        Utils.loadParticleSystem(xmlFile, self.PickUpParticleSystems, namei, nodei, false, nil, self.baseDirectory)
		i = i +1;
    end;

	self.inrange = false;
end;

function JohnDeere864:delete()
	Utils.deleteParticleSystem(self.PickUpParticleSystems);
end;

function JohnDeere864:readStream(streamId, connection)
    self:setPickup(streamReadBool(streamId), true);
	self:setTransport(streamReadBool(streamId), true);
end;

function JohnDeere864:writeStream(streamId, connection)
    streamWriteBool(streamId, self.Pickup);
	streamWriteBool(streamId, self.Transport);
end;

function JohnDeere864:readUpdateStream(streamId, timestamp, connection)
end;

function JohnDeere864:writeUpdateStream(streamId, connection, dirtyMask)
end;

function JohnDeere864:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeere864:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeere864:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			if self.Transport == true then
				self:setPickup(not self.Pickup);
			end;
		end;
    end;
	-- Manage key events for inrange --
	if self.inrange then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setTransport(not self.Transport);
		end;
	end;
	-- Display key when in range --
	if self.inrange then
		if not self.PickupDown then
			if self.fieldMode then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORT_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("FIELD_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
	end;
end;

function JohnDeere864:updateTick(dt)
	if self:getIsActive() then
		-- Animating the pickup elements --
		if self.isTurnedOn then
			for i=1, 4 do
				rotate(self.RotParts[i], -0.01 * dt, 0, 0);
			end;
			if self.PickupDown then
				rotate(self.FeederRoll, 2.5 * self.lastSpeedReal * self.movingDirection * dt ,0,0);
			end;
		end;
		if self.PickupDown then
			rotate(self.PickupWheel1, 2.5 * self.lastSpeedReal * self.movingDirection * dt ,0,0);
			rotate(self.PickupWheel2, 2.5 * self.lastSpeedReal * self.movingDirection * dt ,0,0);
		end;
		-- Activate particles --
		if self.isTurnedOn and self.movingDirection ~= 0 and self.PickupDown then
			Utils.setEmittingState(self.PickUpParticleSystems, true);
		else
			Utils.setEmittingState(self.PickUpParticleSystems, false);
		end;
	end;
	if self.attacherVehicle and g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.inrange = true;
		else
			self.inrange = false;
		end;
	end;
end;

function JohnDeere864:draw()
	if self.PickupDown then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_LIFT"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_LOWER"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
	end;
	if self.isClient then
		if self.isTurnedOn and not self.fieldMode then
			g_currentMission:addWarning(g_i18n:getText("SWITCH_TO_FIELD_MODE"), 0.07+0.022, 0.019+0.029);
		end;
	end;
end;

function JohnDeere864:setPickup(isPickupState,noEventSend)
	SetPickupEvent.sendEvent(self, isPickupState, noEventSend);
	-- Play pickup animation --
	self.PickupDown = isPickupState;
	if self.PickupDown then
		if self.PickupAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PickupAnimation, -1, nil, true);
			self.Pickup = true;
		end;
	else
		if self.PickupAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PickupAnimation, 1, nil, true);
			self.Pickup = false;
		end;
	end;
end;

function JohnDeere864:setTransport(isTransportState,noEventSend)
	SetTransportEvent.sendEvent(self, isTransportState, noEventSend);
	-- Transport/field mode --
	self.fieldMode = isTransportState;
	if self.fieldMode then
		setVisibility(self.wheelsInTransportPosition, false);
		setVisibility(self.wheelsInFieldPosition, true);
		self.Transport = true;
	else
		setVisibility(self.wheelsInTransportPosition, true);
		setVisibility(self.wheelsInFieldPosition, false);
		self.Transport = false;
	end;
end;

function JohnDeere864:onDetach()
	if self.PickUpParticleSystems ~= nil then
		Utils.setEmittingState(self.PickUpParticleSystems, false);
	end;
end;

function JohnDeere864:getIsAreaActive(superFunc, area)
    if superFunc ~= nil then
			return superFunc(self, area) and self.PickupDown;
    end;
	return self.PickupDown;
end;
