--
-- BaleCounter
-- Specialization for baler to display a bale counter.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		30/11/10
--

BaleCounter = {};

function BaleCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(BalerVariableChamber, specializations);
end;

function BaleCounter:load(xmlFile)
	self.SetBaleCount= SpecializationUtil.callSpecializationsFunction("SetBaleCount");
	--  HUD --
	self.File = Utils.getFilename("Textures/Balecounter_hud.png", self.baseDirectory);
	self.hudPoxX = 0.8090;
    self.hudPoxY = 0.7140;
    self.hudWidth = 0.186;
    self.hudHeight = 0.192;
    self.HUDNHBB = Overlay:new("HUDNHBB", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
    self.HUD = false;

	self.TotalBalesCount = 0;
	self.CurrentBalesCount = 0;
	self.NoRopesBalesCount = 0;
end;

function BaleCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   local TotalBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#TotalBalesCount"),0);
   local NoRopesBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#NoRopesBalesCount"),0);
   self.TotalBalesCount = TotalBalesCount;
   self.NoRopesBalesCount = NoRopesBalesCount;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function BaleCounter:getSaveAttributesAndNodes(nodeIdent)
   local TotalBalesCount= Utils.getNoNil(self.TotalBalesCount, 0);
   local NoRopesBalesCount= Utils.getNoNil(self.NoRopesBalesCount, 0);
    local attributes = 'TotalBalesCount="'..string.format("%.1f",TotalBalesCount)..'" NoRopesBalesCount="'..string.format("%.1f",NoRopesBalesCount)..'"';
   return attributes, nil;
end;

function BaleCounter:delete()
end;

function BaleCounter:readStream(streamId, connection)
    self.TotalBalesCount = streamReadInt32(streamId);
    self.NoRopesBalesCount = streamReadInt32(streamId);
    self.CurrentBalesCount = streamReadInt32(streamId);
end;

function BaleCounter:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.TotalBalesCount);
    streamWriteInt32(streamId, self.NoRopesBalesCount);
    streamWriteInt32(streamId, self.CurrentBalesCount);
end;

function BaleCounter:readUpdateStream(streamId, timestamp, connection)
end;

function BaleCounter:writeUpdateStream(streamId, connection, dirtyMask)
end;

function BaleCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BaleCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function BaleCounter:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
			self.HUD = not self.HUD;
		end;
    end;
end;

function BaleCounter:updateTick(dt)
end;

function BaleCounter:draw()
	setTextBold(true);
	setTextColor(1, 1, 1, 1.0);
	if self.HUD then
		self.HUDNHBB:render();
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
		if self.CurrentBalesCount~= nil then
			renderText(0.8850, 0.822, 0.040, string.format(self.CurrentBalesCount));
		end;
		if self.TotalBalesCount~= nil then
			renderText(0.8850, 0.760, 0.040, string.format(self.TotalBalesCount));
		end;
	else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
	end;
end;

function BaleCounter.dropBale(self, baleIndex)
	if self.CurrentBalesCount ~= nil and self.TotalBalesCount ~= nil and self.NoRopesBalesCount ~= nil then
		self.CurrentBalesCount = self.CurrentBalesCount +1;
		self.TotalBalesCount = self.TotalBalesCount +1;
		self.NoRopesBalesCount = self.NoRopesBalesCount +1;
	end;
end;
