-- xyzspain
-- fix fin050808

P300= {};

function P300.prerequisitesPresent(specializations)
  -- return SpecializationUtil.hasSpecialization(Trailer, specializations);
   return true;
end;

function P300:load(xmlFile)
	-- desplazamiento de conjuntos1
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	-- animacion1
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.animParts = {}
	self.Activated = {};
	------
	self.startpoint = {};
	self.loopCheck = {};
	self.Speed = {};
	
	
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
		local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.Activated[nameR] = false;
		-----
		self.startpoint[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#startpoint"),0.0);
		local charId = getAnimCharacterSet(self.charId[nameR]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[nameR]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackTime(charId, 0, self.startpoint[nameR]);
		enableAnimTrack(charId, 0);
		disableAnimTrack(charId, 0);
		self.loopCheck[nameR] = false;
		self.Speed[nameR] = 1.0;
		
		
		
	end; 	
	
	self.AllActivated = SpecializationUtil.callSpecializationsFunction("AllActivated");
	------
	
	-------78------------------
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
	 self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
			--78----------------------
    local spraySound = getXMLString(xmlFile, "vehicle.spraySound#file");
    if spraySound ~= nil and spraySound ~= "" then
        spraySound = Utils.getFilename(spraySound, self.baseDirectory); 
        self.spraySound = createSample("spraySound");
        self.spraySoundEnabled = false;
        loadSample(self.spraySound, spraySound, false);
        self.spraySoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.spraySound#pitchOffset"), 1);
        self.spraySoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.spraySound#volume"), 1);
    end;


	-----78--------
	local sound1 = getXMLString(xmlFile, "vehicle.sound1#file");
    if sound1 ~= nil and sound1 ~= "" then
        sound1 = Utils.getFilename(sound1, self.baseDirectory); 
        self.sound1 = createSample("sound1");
        self.sound1Enabled = false;
        loadSample(self.sound1, sound1, false);
        self.sound1PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound1#pitchOffset"), 1);
        self.sound1Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound1#volume"), 1);
    end;
	local sound2 = getXMLString(xmlFile, "vehicle.sound2#file");
    if sound2 ~= nil and sound2 ~= "" then
        sound2 = Utils.getFilename(sound2, self.baseDirectory); 
        self.sound2 = createSample("sound2");
        self.sound2Enabled = false;
        loadSample(self.sound2, sound2, false);
        self.sound2PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound2#pitchOffset"), 1);
        self.sound2Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound2#volume"), 1);
    end;

	------cutting1
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].groundthreshold = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#groundthreshold"), 0.2);
        self.cuttingAreas[i].groundindex = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#groundindex"));
    end;
	
	--- ajuste altura tractor1
	local count = getXMLInt(xmlFile, "vehicle.rotationParts#count");
	if count ~= nil then
		self.rotationParts = {}
		local rotationPart = self.rotationParts;
		for i=1, count do
			local varName = string.format("rotationPart" .. "%d", i);
			rotationPart[varName] = {};
			local rotationPartname = string.format("vehicle.rotationParts.rotationPart" .. "%d", i);
			rotationPart[varName].index = Utils.indexToObject(self.components, getXMLString(xmlFile, rotationPartname .. "#index"));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#minRot"));
			rotationPart[varName].minRot = {};
			rotationPart[varName].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#maxRot"));
			rotationPart[varName].maxRot = {};
			rotationPart[varName].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			rotationPart[varName].rotTime = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#rotTime"), 2)*1000;	
			rotationPart[varName].touchRotLimit = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#touchRotLimit"), 1)/1000;	
		end;
	end;

	----------------
	-- self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	
	self.AIon=false;
	
	self.turnOn=false;
	----	
end;
function P300:delete()
--if self.spraySound ~= nil then
--        delete(self.spraySound);
--    end;
 Utils.setEmittingState(self.sprayParticleSystems, false)

 if self.sound1 ~= nil then
        delete(self.sound1);
    end;
	if self.sound2 ~= nil then
        delete(self.sound2);
    end;
end;
function P300:mouseEvent(posX, posY, isDown, isUp, button)
end;

function P300:keyEvent(unicode, sym, modifier, isDown)
if isDown and sym == Input.KEY_KP_7 then
		self.down=true;
	else
		self.down=false;
	end;
	if isDown and sym == Input.KEY_KP_4 then
		self.up=true;
	else
--		self.up=false;
	end;
end;

	
	
function P300:update(dt)
		if self.Go.foldRightCharSet01 ~= nil and self.Done.foldRightCharSet01 ~= false then
			self:anim("foldRightCharSet01", false); 
		end;
		if self.Go.foldLeftCharSet01 ~= nil and self.Done.foldLeftCharSet01 ~= false then
			self:anim("foldLeftCharSet01", false); 
		end;
		
		
if self.attacherVehicle then
	if self.fixAttacher then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.saveJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.maxRotJoint = joint.maxRotLimit;
				self.attacherJointIndex = implement.jointDescIndex;
				self.rotationCopy  = joint.minRot;
				joint.minRot = {Utils.degToRad(2),0,0};			
				joint.maxRotLimit = {0, 0, 0};
				setJointRotationLimit(joint.jointIndex, 2, true, 0, 0);
			end;
			self.fixAttacher = false;
		end;
	--------
		self.Speed.foldRightCharSet01 = 1.0; 
		self.Speed.foldLeftCharSet01 = 1.0; 
	------
	if self:getIsActive()  then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
		
				 self.Go.foldRightCharSet01 = not self.Go.foldRightCharSet01;
					self.Done.foldRightCharSet01= true;
			if not self.sound1Enabled  and not self.AIon and self:getIsActiveForSound() then
			setSamplePitch(self.sound1, self.sound1PitchOffset);
			playSample(self.sound1, 0, self.sound1Volume, 0);
			self.sound1Enabled = true;
			end;	
		
		end;
		 if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				 self.Go.foldLeftCharSet01 = not self.Go.foldLeftCharSet01;
					self.Done.foldLeftCharSet01= true;
				
			if not self.sound2Enabled  and not self.AIon and self:getIsActiveForSound() then
			setSamplePitch(self.sound2, self.sound2PitchOffset);
			playSample(self.sound2, 0, self.sound2Volume, 0);
			self.sound2Enabled = true;
			end;
		end;
	end;
	

		
		
		
		
		if (self.CheckDone["foldRightCharSet01"] == true) and self.Activated["foldRightCharSet01"] == false then
			if   self.Go.foldRightCharSet01 then 			
				if self.sound1Enabled then
					stopSample(self.sound1);
					self.sound1Enabled = false;
				end;
			end;
		elseif (self.CheckDone["foldRightCharSet01"] == false) and self.Activated["foldRightCharSet01"] == true then
			if  not self.Go.foldRightCharSet01 then 
				if self.sound1Enabled then
					stopSample(self.sound1);
					self.sound1Enabled = false;
				end;
			end;
		
		end;		
		
		if (self.CheckDone["foldLeftCharSet01"] == true) and self.Activated["foldLeftCharSet01"] == false then
			if  self.Go.foldLeftCharSet01 then		
				if self.sound2Enabled then
					stopSample(self.sound2);
					self.sound2Enabled = false;
				end;
			end;
		elseif (self.CheckDone["foldLeftCharSet01"] == false) and self.Activated["foldLeftCharSet01"] == true then
			if  not self.Go.foldLeftCharSet01 then
				if self.sound2Enabled then
					stopSample(self.sound2);
					self.sound2Enabled = false;
				end;
				 -- renderText(0.1, 0.09, 0.03," sound2 off" );	
			end;
		end;


		
		
						
						
			if self:getIsActive()  then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				self.turnOn = not self.turnOn;
				
			end;
			end;
		
		
		
		 if self.fillLevel == 0 then												--
		     if self.spraySoundEnabled then
		         stopSample(self.spraySound);
		         self.spraySoundEnabled = false;
			 end;
			Utils.setEmittingState(self.sprayParticleSystems, false)

		 self.turnOn = false; 
 end; 
				
		if self.turnOn then
			
			
						if not self.spraySoundEnabled and not self.AIon and self:getIsActiveForSound() then
							setSamplePitch(self.spraySound, self.spraySoundPitchOffset);
							playSample(self.spraySound, 0, self.spraySoundVolume, 0);
							self.spraySoundEnabled = true;
						end;
			
			-- local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
			-- local deltaLevel = FruitUtil.fruitIndexToDesc[self.currentFillType].literPerQm * difficultyMultiplier * self.literPerSecond;
			-- self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
			local area = 0;
			for k, cuttingArea in pairs(self.cuttingAreas) do
			    local x,y,z = getWorldTranslation(cuttingArea.groundindex);
	            local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				if (k == 1 or  k == 2 or k == 3 or k == 4 or  k == 5 )and cuttingArea.groundindex ~= nil and terrainHeight+cuttingArea.groundthreshold >= y then
					local x,y,z = getWorldTranslation(cuttingArea.start);
					local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
					local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
					area = Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					if k==1 then
					Utils.setEmittingState(self.sprayParticleSystems, true)
					end;
					if (k==2 or k==3) then
					Utils.setEmittingState(self.spray1ParticleSystems, true)
					end;
					if (k==4 or k==5)  then
					Utils.setEmittingState(self.spray2ParticleSystems, true)
					end;
				end;
				
			end;
			if  not self.Go.foldRightCharSet01 then 	
			Utils.setEmittingState(self.spray1ParticleSystems, false)
			end;	
			if  not self.Go.foldLeftCharSet01 then 	
			Utils.setEmittingState(self.spray2ParticleSystems, false)			
			end;
		else
			if self.spraySoundEnabled then
		        stopSample(self.spraySound);
		        self.spraySoundEnabled = false;
			end;
				Utils.setEmittingState(self.sprayParticleSystems, false)
				Utils.setEmittingState(self.spray1ParticleSystems, false)
				Utils.setEmittingState(self.spray2ParticleSystems, false)	
		end; 	
		
		
		
		
end;


--[[if self.translation1Max ~= nil then
					local x, y, z = getTranslation(self.translation1.node);
					local trans = {x,y,z};
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1Max);
					setTranslation(self.translation1.node, unpack(newTrans));
				end;
if self.down then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
	    end;		
		if self.up then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
	    end;  ]]
-- juntas

		local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[5];
			setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[6];
			setJointFrame(joint.jointIndex, 0,joint.jointNode);
	self:setHydraulicDirection();


end;

function P300:draw()
	
	
if self.AIon == false then
		--g_currentMission:addExtraPrintText(g_i18n:getText(self.vehicleType..".4"));
		 g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".1"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2); 
		 --g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".2"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2); 
	if (self.CheckDone["foldLeftCharSet01"] == true) and self.Activated["foldLeftCharSet01"] == false  or  (self.CheckDone["foldRightCharSet01"] == true) and self.Activated["foldRightCharSet01"] == false then
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".3"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA); 
	
	end;
end;
end;
function P300:onAttach()

self.fixAttacher=true
self.translation1Max = true;

end;

function P300:onDetach()
self.translation1Max = false;
    if self.deactivateOnDetach then
        P300.onDeactivate(self);
    else
        P300.onDeactivateSounds(self)
    end;
Utils.setEmittingState(self.sprayParticleSystems, false)
Utils.setEmittingState(self.spray1ParticleSystems, false)
Utils.setEmittingState(self.spray2ParticleSystems, false)


 	local joint = self.saveJoint; 
	joint.minRot = self.rotationCopy;
	joint.maxRotLimit = self.maxRotJoint;
end;

function P300:onLeave()

    if self.deactivateOnLeave then
        P300.onDeactivate(self);
    else
        P300.onDeactivateSounds(self)
    end;

end;

function P300:onDeactivate()

    P300.onDeactivateSounds(self)
   

end;

function P300:onDeactivateSounds()
 if self.spraySoundEnabled then
        stopSample(self.spraySound);
        self.spraySoundEnabled = false;
    end;
   
	 if self.sound1Enabled then
        stopSample(self.sound1);
        self.sound1Enabled = false;
    end;
	 if self.sound2Enabled then
        stopSample(self.sound2);
        self.sound2Enabled = false;
    end;
			
end;

function P300:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;
function P300:anim(varName, loopCheck)	
	-- print("ANIMATION");
	
	self.Activated[varName] = true;
	local loopCheck = self.loopCheck[varName];
	local speed = Utils.getNoNil(self.Speed[varName],1);
	 
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, speed);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
			self.Activated[varName] = false;
		
			---final animacion hacia delante
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -speed);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
			self.Activated[varName] = true;
			---final animacion hacia atras
		
		end;
	end;
end; 


function P300:AllActivated()
	
	if (self.CheckDone["foldRightCharSet01"] == true) and not self.Activated["foldRightCharSet01"]  then
		return true;
	else
		return false;
	end;
	if (self.CheckDone["foldLeftCharSet01"] == true) and not self.Activated["foldLeftCharSet01"]  then
		return true;
	else
		return false;
	end;
	
	
end;
function P300:getSaveAttributesAndNodes(nodeIdent)
if (self.CheckDone["foldRightCharSet01"] == true) and self.Activated["foldRightCharSet01"] == false then
					
	foldRightCharSet01 = "true";	
else		
	foldRightCharSet01 = "false";	
end;		
		
if (self.CheckDone["foldLeftCharSet01"] == true) and self.Activated["foldLeftCharSet01"] == false then
	foldLeftCharSet01 = "true";	
else		
	foldLeftCharSet01 = "false";	
end;		
	---'name="'..tostring(name)..'" name="'..tonumber(name)..'"';
	 local attributes = 'foldRightCharSet01="'..tostring(foldRightCharSet01)..'" foldLeftCharSet01="'..tostring(foldLeftCharSet01)..'"';
	
	return attributes, nil;
end;


function P300:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local foldRightCharSet01 = getXMLString(xmlFile, key.."#foldRightCharSet01");
	 local foldLeftCharSet01 = getXMLString(xmlFile, key.."#foldLeftCharSet01");
	if foldRightCharSet01 == "true" and not resetVehicles then
		self.Go.foldRightCharSet01 = not self.Go.foldRightCharSet01 ; 
		self.Done.foldRightCharSet01 = true; 
		self.Speed.foldRightCharSet01 = 10.0; 
	end; 
	if foldLeftCharSet01 == "true" and not resetVehicles then
		self.Go.foldLeftCharSet01 = not self.Go.foldLeftCharSet01 ; 
		self.Done.foldLeftCharSet01 = true; 
		self.Speed.foldLeftCharSet01 = 10.0; 
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;
function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;