--
-- cserevilla
-- LS UK Modteam
--
-- author Henly20
-- date  20/11/2010
--

cserevilla = {};

function cserevilla.prerequisitesPresent(specializations)
    return true;
end;

function cserevilla:load(xmlFile)

	self.setDuelWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDuelWheelsVisibility");
	self.setDuelFWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDuelFWheelsVisibility");
	
      self.duelWheels = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.duelWheels.duelWheel(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.duelWheels, {node=node});
          end;
          i = i + 1;
      end;

      self.duelFWheels = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.duelFWheels.duelFWheel(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.duelFWheels, {node=node});
          end;
          i = i + 1;
      end;
end;

function cserevilla:delete()

end;

function cserevilla:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setDuelWheelsVisibility(visibility, true);
	local visibilityfront = streamReadBool(streamId);
	self:setDuelFWheelsVisibility(visibilityfront, true);
	
end;

function cserevilla:writeStream(streamId, connection)
	streamWriteBool(streamId, self.duelWheelsActive);
	streamWriteBool(streamId, self.duelFWheelsActive);
	
end;

function cserevilla:mouseEvent(posX, posY, isDown, isUp, button)
end;

function cserevilla:keyEvent(unicode, sym, modifier, isDown)
end;

function cserevilla:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.villacsere) then
              self:setDuelWheelsVisibility(not self.duelWheelsActive);
			  self:setDuelFWheelsVisibility(not self.duelFWheelsActive);
          end;
	end;
end;

function cserevilla:updateTick(dt)



end;

function cserevilla:onLeave()

end;

function cserevilla:draw()

end;

function cserevilla:setDuelWheelsVisibility(visibility, noEventSend)
      if visibility ~= self.duelWheelsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(Setvilla1Event:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(Setvilla1Event:new(self, visibility));
              end;
          end;
  
          self.duelWheelsActive = visibility;
  
          for _, duelWheel in pairs(self.duelWheels) do
             setVisibility(duelWheel.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setDuelWheelsVisibility ~= nil then
                 v.setDuelWheelsVisibility(self, visibility);
              end;
          end;
      end;
end;

function cserevilla:setDuelFWheelsVisibility(visibilityfront, noEventSend)
      if visibilityfront ~= self.duelFWheelsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetvillaEvent:new(self, visibilityfront), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetvillaEvent:new(self, visibilityfront));
              end;
          end;
  
          self.duelFWheelsActive = visibilityfront;
  
          for _, duelFWheel in pairs(self.duelFWheels) do
             setVisibility(duelFWheel.node, visibilityfront);
          end;
          for _,v in pairs(self.specializations) do
              if v.setDuelFWheelsVisibility ~= nil then
                 v.setDuelFWheelsVisibility(self, visibilityfront);
              end;
          end;
      end;
end;