SetvillaEvent = {};
SetvillaEvent_mt = Class(SetvillaEvent, Event);

InitEventClass(SetvillaEvent, "SetvillaEvent");

function SetvillaEvent:emptyNew()
      local self = Event:new(SetvillaEvent_mt);
      self.className="SetvillaEvent";
      return self;
end;

function SetvillaEvent:new(object, active)
      local self = SetvillaEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;

function SetvillaEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
 end;

function SetvillaEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;

function SetvillaEvent:run(connection)
      self.object:setDuelFWheelsVisibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetvillaEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;