Setvilla1Event = {};
Setvilla1Event_mt = Class(Setvilla1Event, Event);

InitEventClass(Setvilla1Event, "Setvilla1Event");

function Setvilla1Event:emptyNew()
      local self = Event:new(Setvilla1Event_mt);
      self.className="Setvilla1Event";
      return self;
end;

function Setvilla1Event:new(object, active)
      local self = Setvilla1Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;

function Setvilla1Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
 end;

function Setvilla1Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;

function Setvilla1Event:run(connection)
      self.object:setDuelWheelsVisibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setvilla1Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;