-- BaleToGrass Skript by Ifkonator
-- Erstellt am: 14.09.2014


BaleToGrass = {}

local BaleToGrass_mt = Class(BaleToGrass, Object);

function baleToGrassOnCreate(id)
	local trigger = BaleToGrass:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
end;

g_onCreateUtil.addOnCreateFunction("baleToGrassOnCreate", baleToGrassOnCreate);

function BaleToGrass:new(isServer, isClient)
	local self = Object:new(isServer, isClient, BaleToGrass_mt);
	self.className = "BaleToGrass";
	return self;
end;

function BaleToGrass:delete()
	removeTrigger(self.triggerId);
end;

function BaleToGrass:load(id)
	self.triggerId = id;
	addTrigger(self.triggerId, "triggerCallback", self);
end;

function BaleToGrass:update(dt)
end;

function BaleToGrass:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_server ~= nil then
		local object = g_currentMission:getNodeObject(otherId);
		if object ~= nil and object:isa(Bale) and object.fillType == Fillable.FILLTYPE_GRASS_WINDROW or object.fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW then
			if not (object.isAttached ~= nil and object.isAttached) then
				g_currentMission:setSiloAmount(Fillable.FILLTYPE_GRASS_WINDROW, g_currentMission:getSiloAmount(Fillable.FILLTYPE_GRASS_WINDROW) + object.fillLevel);
				object:delete();
			end;
		end;
	end;
end;