SetScattererEvent = {};
SetScattererEvent_mt = Class(SetScattererEvent, Event);

InitEventClass(SetScattererEvent, "SetScattererEvent");

function SetScattererEvent:emptyNew()
    local self = Event:new(SetScattererEvent_mt);
    self.className="SetScattererEvent";
    return self;
end;

function SetScattererEvent:new(vehicle, isScatterer)
    local self = SetScattererEvent:emptyNew()
    self.vehicle = vehicle;
	self.ScattererPos = isScatterer;
    return self;
end;

function SetScattererEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.ScattererPos = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetScattererEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.ScattererPos);
end;

function SetScattererEvent:run(connection)   
	self.vehicle:setScatterer(self.ScattererPos, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetScattererEvent:new(self.vehicle, self.ScattererPos), nil, connection, self.vehicle);
    end;
end;

function SetScattererEvent.sendEvent(vehicle, isScatterer, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetScattererEvent:new(vehicle, isScatterer), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetScattererEvent:new(vehicle, isScatterer));
		end;
	end;
end;