--
-- GillesTR16
-- Specialization for the Gilles TR16 topper 
--
-- @author  	Stefan Geiger - GIANTS Software 
-- @Edited version  Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		04/01/11
-- Due to the need of managing the sugarbeet instead of the grass, it is necessary to take some parts of the original "mower" script.

GillesTR16 = {};

function GillesTR16.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function GillesTR16:load(xmlFile)
	--------------------------
	-- Original  script --
	--------------------------
	
	--------------------------
	-- Personnal script --
	--------------------------
	
	self.setScatterer= SpecializationUtil.callSpecializationsFunction("setScatterer");
	

	-- UV Scroll for the inside track --
    self.TrackUVScrollParts = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.TrackUVScrollParts.TrackUVScrollPart(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
			break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
         if node ~= nil and speed then
              table.insert(self.TrackUVScrollParts, {node=node, speed=speed});
        end;
        i = i +1;
    end;
	-- Animations --
	self.ScattererAnimation = getXMLString(xmlFile, "vehicle.Scatterer#animationName");
	self.Scatterer = false;
	-- chopper --
	self.chopper = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopper#index"));
	-- scatterer's disc -- 
	self.scatDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.scatDisc#index"));
	-- Particles--
	-- scatterer particle --
    self.scattererParticleSystem = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.scattererParticleSystem.scattererParticleSystem(%d)", i);
        local particleSystem = {};
        particleSystem.ps = {};
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#index"));
		if nodei == nil then
			break;
		end; 
        local ps = Utils.loadParticleSystem(xmlFile, particleSystem.ps, baseName, nodei, false, nil, self.baseDirectory)
        if ps == nil then
            break;
        end;
        particleSystem.isEnabled = false;
        table.insert(self.scattererParticleSystem, particleSystem);
        i = i+1;
    end;
	self.scattererParticleSystemFlag = self:getNextDirtyFlag();
	
    self.workingParticleSystem = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.workingParticleSystem.workingParticleSystem(%d)", i);
        local particleSystem = {};
        particleSystem.ps = {};
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#index"));
		if nodei == nil then
			break;
		end; 
        local ps = Utils.loadParticleSystem(xmlFile, particleSystem.ps, baseName, nodei, false, nil, self.baseDirectory)
        if ps == nil then
            break;
        end;
        particleSystem.isEnabled = false;
        table.insert(self.workingParticleSystem, particleSystem);
        i = i+1;
    end;
	self.workingParticleSystemFlag = self:getNextDirtyFlag();
	
	-- Working Sound --
    local workingSound = getXMLString(xmlFile, "vehicle.workingSound#file");
    if workingSound ~= nil and workingSound ~= "" then
        workingSound = Utils.getFilename(workingSound, self.baseDirectory); 
        self.workingSound = createSample("workingSound");
        self.workingSoundEnabled = false;
        loadSample(self.workingSound, workingSound, false);
        self.workingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workingSound#pitchOffset"), 1);
        self.workingSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workingSound#volume"), 1);
    end;


end;

function GillesTR16:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

end;

function GillesTR16:getSaveAttributesAndNodes(nodeIdent)

end;

function GillesTR16:delete()
    Utils.deleteParticleSystem(self.scattererParticleSystem);
    Utils.deleteParticleSystem(self.workingParticleSystem);
    if self.workingSound ~= nil then
        delete(self.workingSound);
    end;
end;

function GillesTR16:readStream(streamId, connection)
    local isScatterer = streamReadBool(streamId);
	self:setScatterer(isScatterer, true);
end;

function GillesTR16:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isScatterer);
end;

function GillesTR16:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		local hasUpdate = streamReadBool(streamId);
		if hasUpdate then
			for k,v in ipairs(self.workingParticleSystem) do
				local enabled = streamReadBool(streamId);
				Utils.setEmittingState(v.ps, enabled);
			end;
		end;
		local hasUpdate = streamReadBool(streamId);
		if hasUpdate then
			for k,v in ipairs(self.scattererParticleSystem) do
				local enabled = streamReadBool(streamId);
				Utils.setEmittingState(v.ps, enabled);
			end;
		end;
	end;
end;

function GillesTR16:writeUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        if bitAND(dirtyMask, self.workingParticleSystemFlag) ~= 0 then
            streamWriteBool(streamId, true);
            for k,v in ipairs(self.workingParticleSystem) do
                streamWriteBool(streamId, v.isEnabled);
            end;
        else
            streamWriteBool(streamId, false);
        end;
        if bitAND(dirtyMask, self.scattererParticleSystemFlag) ~= 0 then
            streamWriteBool(streamId, true);
            for k,v in ipairs(self.scattererParticleSystem) do
                streamWriteBool(streamId, v.isEnabled);
            end;
        else
            streamWriteBool(streamId, false);
        end;
    end;
end;

function GillesTR16:mouseEvent(posX, posY, isDown, isUp, button)
end;

function GillesTR16:keyEvent(unicode, sym, modifier, isDown)
end;

function GillesTR16:update(dt)		
    if self:getIsActiveForInput() then
		-- Trigger the scatterer's animation --
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setScatterer(not self.Scatterer);
		end;
    end;
	
	if self:getIsActive() then
		
		-- Handling UV Scroll --
		for _, part in pairs(self.TrackUVScrollParts) do
			if self.isTurnedOn then
				setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
			else
				setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
			end;
		end;
		
        if self.isTurnedOn then
		-- chopper rotation --
			rotate(self.chopper, -0.05 * dt, 0, 0 );
		-- scatterer's disc rotation --
			if self.isScatterer then
				rotate (self.scatDisc, 0, 1 * dt, 0 );
			end;
		end;
	end;
end;

function GillesTR16:updateTick(dt)	
	if self:getIsActive() then
        if self.isTurnedOn then
		-- Calling a new AreaEvent script to handle sugarbeet instead of grass
            if self.isServer then
                local x,y,z = getWorldTranslation(self.groundReferenceNode);
                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                if terrainHeight+self.groundReferenceThreshold >= y then
                    local cuttingAreasSend = {};
                    for k, cuttingArea in pairs(self.cuttingAreas) do
                        if self:getIsAreaActive(cuttingArea) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                            table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                        end;
                    end;
                    if (table.getn(cuttingAreasSend) > 0) then
                        SugarBeetMowerAreaEvent.runLocally(cuttingAreasSend);
                        g_server:broadcastEvent(SugarBeetMowerAreaEvent:new(cuttingAreasSend));
					end;					
					-- Particles --
						if self.lastSpeed*3600 > 2 then
							if self.isScatterer then
								for k,v in pairs (self.scattererParticleSystem) do
									if not v.isEnabled then
										v.isEnabled = true;
										self:raiseDirtyFlags(self.scattererParticleSystemFlag);
										if self.isClient then
											Utils.setEmittingState(v.ps, true);
										end;
									end;
								end;
							elseif not self.isScatterer then
								for k,v in pairs (self.scattererParticleSystem) do
									if v.isEnabled then
										v.isEnabled = false;
										self:raiseDirtyFlags(self.scattererParticleSystemFlag);
										if self.isClient then
											Utils.setEmittingState(v.ps, false);
										end;
									end;
								end;
							end;
							for k,v in pairs (self.workingParticleSystem) do
								if not v.isEnabled then
									v.isEnabled = true;
									self:raiseDirtyFlags(self.workingParticleSystemFlag);
									if self.isClient then
										Utils.setEmittingState(v.ps, true);
									end;
								end;
							end;						
						elseif self.lastSpeed*3600 < 2 then
							for k,v in pairs (self.scattererParticleSystem) do
								if v.isEnabled then
									v.isEnabled = false;
									self:raiseDirtyFlags(self.scattererParticleSystemFlag);
									if self.isClient then
										Utils.setEmittingState(v.ps, false);
									end;
								end;
							end;
							for k,v in pairs (self.workingParticleSystem) do
								if v.isEnabled then
									v.isEnabled = false;
									self:raiseDirtyFlags(self.workingParticleSystemFlag);
									if self.isClient then
										Utils.setEmittingState(v.ps, false);
									end;
								end;
							end;							
						end;
				else
					for k,v in pairs (self.scattererParticleSystem) do
						if v.isEnabled then
							v.isEnabled = false;
							self:raiseDirtyFlags(self.scattererParticleSystemFlag);
							if self.isClient then
								Utils.setEmittingState(v.ps,false);
							end;
						end;
					end;
					for k,v in pairs (self.workingParticleSystem) do
						if v.isEnabled then
							v.isEnabled = false;
							self:raiseDirtyFlags(self.workingParticleSystemFlag);
							if self.isClient then
								Utils.setEmittingState(v.ps, false);
							end;
						end;
					end;	
				end;
			end;
		else
			for k,v in pairs (self.scattererParticleSystem) do
				if v.isEnabled then
					v.isEnabled = false;
					self:raiseDirtyFlags(self.scattererParticleSystemFlag);
					if self.isClient then
						Utils.setEmittingState(v.ps, false);
					end;
				end;
			end;	
			for k,v in pairs (self.workingParticleSystem) do
				if v.isEnabled then
					v.isEnabled = false;
					self:raiseDirtyFlags(self.workingParticleSystemFlag);
					if self.isClient then
						Utils.setEmittingState(v.ps, false);
					end;
				end;
			end;	
		end;
	end;
end;

function GillesTR16:draw()
	if self.Scatterer then
	    g_currentMission:addHelpButtonText(string.format(g_i18n:getText("DEACTIVATE_SCAT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
	else
	    g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ACTIVATE_SCAT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
	end;
end;

function GillesTR16:onDetach()
	self.isTurnedOn = false;
	for _, part in pairs(self.TrackUVScrollParts) do
		setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
	end;
	if self.deactivateOnDetach then
		GillesTR16.onDeactivate(self);
	else
		GillesTR16.onDeactivateSounds(self);
	end;
end;

function GillesTR16:onLeave()
	self.isTurnedOn = false;
	if self.deactivateOnLeave then
		GillesTR16.onDeactivate(self);
	else
		GillesTR16.onDeactivateSounds(self);
	end;
end;

function GillesTR16:onDeactivate()

	GillesTR16.onDeactivateSounds(self);
	self.isTurnedOn = false;
	for k,v in pairs (self.scattererParticleSystem) do
		if v.isEnabled then
			v.isEnabled = false;
			self:raiseDirtyFlags(self.scattererParticleSystemFlag);
			if self.isClient then
				Utils.setEmittingState(v.ps, false);
			end;
		end;
	end;
	for k,v in pairs (self.workingParticleSystem) do
		if v.isEnabled then
			v.isEnabled = false;
			self:raiseDirtyFlags(self.workingParticleSystemFlag);
			if self.isClient then
				Utils.setEmittingState(v.ps, false);
			end;
		end;
	end;	
	for _, part in pairs(self.TrackUVScrollParts) do
		setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
	end;
end;

function GillesTR16:onDeactivateSounds()
	self.isTurnedOn = false;
	if self.workingSoundEnabled then
		stopSample(self.workingSound);
		self.workingSoundEnabled = false;
	end;
end;

function GillesTR16:setIsTurnedOn(isTurnedOn, noEventSend)
    SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend)
    self.isTurnedOn = isTurnedOn;
	if self.isTurnedOn then
		if not self.workingSoundEnabled and self:getIsActiveForSound() then
			setSamplePitch(self.workingSound, self.workingSoundPitchOffset);
			playSample(self.workingSound, 0, self.workingSoundVolume, 0);
			self.workingSoundEnabled = true;
		end;
	else
		if self.workingSoundEnabled then
			stopSample(self.workingSound);
			self.workingSoundEnabled = false;
		end;	
	end;
end;

function GillesTR16:setScatterer(isScatterer,noEventSend)
	SetScattererEvent.sendEvent(self, isScatterer, noEventSend);
	self.isScatterer = isScatterer;
	-- Play scatterer animation --
	if isScatterer then
		if self.ScattererAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ScattererAnimation, -1, nil, true);
			self.Scatterer = true;
		end;
	else
		if self.ScattererAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ScattererAnimation, 1, nil, true);
			self.Scatterer = false;
		end;
	end;
end;