--
-- SetTracers
-- Specialization for sowing machine allowing to manage tracers
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		28/12/10
--

SetTracers = {};

function SetTracers.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(SowingMachine, specializations);
end;

function SetTracers:load(xmlFile)
	self.setLeftTracer= SpecializationUtil.callSpecializationsFunction("setLeftTracer");	
	self.setRightTracer= SpecializationUtil.callSpecializationsFunction("setRightTracer");	
	-- Animations --
	self.LeftTracerAnimation = getXMLString(xmlFile, "vehicle.LeftTracer#animationName");
	self.RightTracerAnimation = getXMLString(xmlFile, "vehicle.RightTracer#animationName");
	self.LeftTracer = false;
	self.RightTracer = false;
end;

function SetTracers:delete()
end;

function SetTracers:readStream(streamId, connection)
    self:setLeftTracer(streamReadBool(streamId), true);
    self:setRightTracer(streamReadBool(streamId), true);
end;

function SetTracers:writeStream(streamId, connection)
    streamWriteBool(streamId, self.LeftTracer);
    streamWriteBool(streamId, self.RightTracer);
end;

function SetTracers:readUpdateStream(streamId, timestamp, connection)
end;

function SetTracers:writeUpdateStream(streamId, connection, dirtyMask)
end;

function SetTracers:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SetTracers:keyEvent(unicode, sym, modifier, isDown)
end;

function SetTracers:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LEFT_TRACER) then
			self:setLeftTracer(not self.LeftTracer);
		end;	
		if InputBinding.hasEvent(InputBinding.RIGHT_TRACER) then
			self:setRightTracer(not self.RightTracer);
		end;
    end;
end;

function SetTracers:updateTick(dt)	
end;

function SetTracers:draw()
	if self.LeftTracer then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("LEFT_TRACER_OFF"), self.typeDesc), InputBinding.LEFT_TRACER);
    else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("LEFT_TRACER_ON"), self.typeDesc), InputBinding.LEFT_TRACER);
	end;
	if self.RightTracer then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("RIGHT_TRACER_OFF"), self.typeDesc), InputBinding.RIGHT_TRACER);
    else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("RIGHT_TRACER_ON"), self.typeDesc), InputBinding.RIGHT_TRACER);
	end;
end;

function SetTracers:setLeftTracer(isLUnfold,noEventSend)
	SetLeftTracerEvent.sendEvent(self, isLUnfold, noEventSend);
	-- Play left tracer animation --
	if isLUnfold then
		if self.LeftTracerAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.LeftTracerAnimation, -1, nil, true);
			self.LeftTracer = true;
		end;
	else
		if self.LeftTracerAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.LeftTracerAnimation, 1, nil, true);
			self.LeftTracer = false;
		end;
	end;
end;

function SetTracers:setRightTracer(isRUnfold,noEventSend)
	SetRightTracerEvent.sendEvent(self, isRUnfold, noEventSend);
	-- Play right tracer animation --
	if isRUnfold then
		if self.RightTracerAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.RightTracerAnimation, -1, nil, true);
			self.RightTracer = true;
		end;
	else
		if self.RightTracerAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.RightTracerAnimation, 1, nil, true);
			self.RightTracer = false;
		end;
	end;
end;