-- 
-- by PeterJ (23/03/2011)
--  


MovingParts = {};

function MovingParts.prerequisitesPresent(specializations)

    return true;
end;

function MovingParts:load(xmlFile)
     self.setRotationMaxPortaEsq = SpecializationUtil.callSpecializationsFunction("setRotationMaxPortaEsq");
     self.setRotationMaxPortaDta = SpecializationUtil.callSpecializationsFunction("setRotationMaxPortaDta");
     self.setRotationMaxVidroTra = SpecializationUtil.callSpecializationsFunction("setRotationMaxVidroTra");
	 
	
	local rotationPartNodePortaEsq = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPortaEsq#index"));
    if rotationPartNodePortaEsq ~= nil then
        self.rotationPortaEsq = {};
        self.rotationPortaEsq.node = rotationPartNodePortaEsq;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPortaEsq#minRot"));
        self.rotationPortaEsq.minRot = {};
        self.rotationPortaEsq.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPortaEsq.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPortaEsq.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPortaEsq#maxRot"));
        self.rotationPortaEsq.maxRot = {};
        self.rotationPortaEsq.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPortaEsq.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPortaEsq.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPortaEsq.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPortaEsq#rotTime"), 2)*1000;
        self.rotationPortaEsq.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPortaEsq#touchRotLimit"), 10));
    end;
	local rotationPartNodePortaDta = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPortaDta#index"));
    if rotationPartNodePortaDta ~= nil then
        self.rotationPortaDta = {};
        self.rotationPortaDta.node = rotationPartNodePortaDta;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPortaDta#minRot"));
        self.rotationPortaDta.minRot = {};
        self.rotationPortaDta.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPortaDta.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPortaDta.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPortaDta#maxRot"));
        self.rotationPortaDta.maxRot = {};
        self.rotationPortaDta.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPortaDta.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPortaDta.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPortaDta.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPortaDta#rotTime"), 2)*1000;
        self.rotationPortaDta.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPortaDta#touchRotLimit"), 10));
    end;
	local rotationPartNodeVidroTra = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationVidroTra#index"));
    if rotationPartNodeVidroTra ~= nil then
        self.rotationVidroTra = {};
        self.rotationVidroTra.node = rotationPartNodeVidroTra;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationVidroTra#minRot"));
        self.rotationVidroTra.minRot = {};
        self.rotationVidroTra.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationVidroTra.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationVidroTra.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationVidroTra#maxRot"));
        self.rotationVidroTra.maxRot = {};
        self.rotationVidroTra.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationVidroTra.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationVidroTra.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationVidroTra.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationVidroTra#rotTime"), 2)*1000;
        self.rotationVidroTra.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationVidroTra#touchRotLimit"), 10));
    end;
	local rotationPartNodeEmbraiagem = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationEmbraiagem#index"));
    if rotationPartNodeEmbraiagem ~= nil then
        self.rotationEmbraiagem = {};
        self.rotationEmbraiagem.node = rotationPartNodeEmbraiagem;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#minRot"));
        self.rotationEmbraiagem.minRot = {};
        self.rotationEmbraiagem.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEmbraiagem.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEmbraiagem.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#maxRot"));
        self.rotationEmbraiagem.maxRot = {};
        self.rotationEmbraiagem.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEmbraiagem.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEmbraiagem.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEmbraiagem.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#rotTime"), 2)*1000;
        self.rotationEmbraiagem.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#touchRotLimit"), 10));
    end;

	local rotationPartNodeAcelerador = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationAcelerador#index"));
    if rotationPartNodeAcelerador ~= nil then
        self.rotationAcelerador = {};
        self.rotationAcelerador.node = rotationPartNodeAcelerador;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationAcelerador#minRot"));
        self.rotationAcelerador.minRot = {};
        self.rotationAcelerador.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationAcelerador.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationAcelerador.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationAcelerador#maxRot"));
        self.rotationAcelerador.maxRot = {};
        self.rotationAcelerador.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationAcelerador.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationAcelerador.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationAcelerador.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationAcelerador#rotTime"), 2)*1000;
        self.rotationAcelerador.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationAcelerador#touchRotLimit"), 10));
    end;
	local rotationPartNodeTravoes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationTravoes#index"));
    if rotationPartNodeTravoes ~= nil then
        self.rotationTravoes = {};
        self.rotationTravoes.node = rotationPartNodeTravoes;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTravoes#minRot"));
        self.rotationTravoes.minRot = {};
        self.rotationTravoes.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTravoes.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTravoes.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTravoes#maxRot"));
        self.rotationTravoes.maxRot = {};
        self.rotationTravoes.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTravoes.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTravoes.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationTravoes.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTravoes#rotTime"), 2)*1000;
        self.rotationTravoes.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTravoes#touchRotLimit"), 10));
    end;

        self.rotationMaxPortaEsq = false;
        self.rotationMaxPortaDta = false;
        self.rotationMaxVidroTra = false;
        self.rotationMaxEmbraiagem = false;
        self.rotationMaxAcelerador = false;
        self.rotationMaxTravoes = false;

	self.armrot = {};
	self.armrot.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.armRot#index"));
	self.armrot.minRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#minRot"))};
	self.armrot.maxRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#maxRot"))};
	self.armrot.Rot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#Rot"))};
	self.armrot.rotTime = getXMLFloat(xmlFile, "vehicle.armRot#rotTime")*1000;
    self.armrot.posX = true;
    self.armrot.posZ = true;

end;

function MovingParts:readStream(streamId, connection)
     self.rotateMax = streamReadBool(streamId);
     if self.rotationPortaEsq ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPortaEsq.node, x, y, z);
      end;
     if self.rotationPortaDta ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPortaDta.node, x, y, z);
      end;
     if self.rotationVidroTra ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationVidroTra.node, x, y, z);
      end;
end;
  
function MovingParts:writeStream(streamId, connection)
      streamWriteBool(streamId, self.rotateMax);
		if self.rotationPortaEsq ~= nil then
          local x, y, z = getRotation(self.rotationPortaEsq.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationPortaDta ~= nil then
          local x, y, z = getRotation(self.rotationPortaDta.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationVidroTra ~= nil then
          local x, y, z = getRotation(self.rotationVidroTra.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function MovingParts:delete()

end;

function MovingParts:keyEvent(unicode, sym, modifier, isDown)	

end;

function MovingParts:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.DOORLEFT) then
				self:setRotationMaxPortaEsq(not self.rotationMaxPortaEsq);
          end;
          if InputBinding.hasEvent(InputBinding.DOORRIGHT) then
				self:setRotationMaxPortaDta(not self.rotationMaxPortaDta);
          end;
          if InputBinding.hasEvent(InputBinding.BACKGLASS) then
				self:setRotationMaxVidroTra(not self.rotationMaxVidroTra);
          end;

	local doRotate = self.rotationJoystickArmmax or self.rotationJoystickArmmin 
	if self.rotationJoystickArm ~= nil and doRotate then
          local x, y, z = getRotation(self.rotationJoystickArm.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationJoystickArm.maxRot, self.rotationJoystickArm.minRot, 3, self.rotationJoystickArm.rotTime, dt, not self.rotationJoystickArmmax);
          setRotation(self.rotationJoystickArm.node, unpack(newRot));
	end;
	local doRotate = self.rotationJoystickToolmax or self.rotationJoystickToolmin 
	if self.rotationJoystickTool ~= nil and doRotate then
          local x, y, z = getRotation(self.rotationJoystickTool.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationJoystickTool.maxRot, self.rotationJoystickTool.minRot, 3, self.rotationJoystickTool.rotTime, dt, not self.rotationJoystickToolmax);
          setRotation(self.rotationJoystickTool.node, unpack(newRot));
	end;

	if self:getIsActiveForInput() and self.isMotorStarted then
		if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POSMAN) then
		    self.armrot.posX = true;
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, true);
		    setRotation(self.armrot.node, newRot[1],y,z);	
	    end;
		if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEGMAN) then
		    self.armrot.posX = false;
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, false );
		    setRotation(self.armrot.node, newRot[1],y,z);		
		end;
		if not InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEGMAN) and not InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POSMAN) then
		    if self.armrot.posX then
		    	x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({x}, self.armrot.minRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, newRot[1],y,z);
            else
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, newRot[1],y,z);		
		    end;
		end;
		if InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POSMAN) then
		 	self.armrot.posZ = true;   
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, true );
		    setRotation(self.armrot.node, x,y,newRot[1]);	
		elseif InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEGMAN) then
		    self.armrot.posZ = false;   
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, false );
		    setRotation(self.armrot.node, x,y,newRot[1]);	
		end;
		if not InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEGMAN) and not InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POSMAN) then
		    if self.armrot.posZ then
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({z}, self.armrot.minRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, x,y,newRot[1]);		
		    else
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, x,y,newRot[1]);		
			end;
		end;
	end;
     end;

     if self:getIsActive() then
        if self.movingDirection ~= 0 then
			self.rotationMaxEmbraiagem = false;
			self.rotationMaxAcelerador = true;
			self.rotationMaxTravoes = false;
        else
			self.rotationMaxEmbraiagem = true;
			self.rotationMaxAcelerador = false;
			self.rotationMaxTravoes = true;
        end;
     end;

end;

function MovingParts:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.rotationPortaEsq ~= nil then
				local x, y, z = getRotation(self.rotationPortaEsq.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPortaEsq.maxRot, self.rotationPortaEsq.minRot, 3, self.rotationPortaEsq.rotTime, dt, not self.rotationMaxPortaEsq);
				setRotation(self.rotationPortaEsq.node, unpack(newRot));
			end;
			if self.rotationPortaDta ~= nil then
				local x, y, z = getRotation(self.rotationPortaDta.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPortaDta.maxRot, self.rotationPortaDta.minRot, 3, self.rotationPortaDta.rotTime, dt, not self.rotationMaxPortaDta);
				setRotation(self.rotationPortaDta.node, unpack(newRot));
			end;
			if self.rotationVidroTra ~= nil then
				local x, y, z = getRotation(self.rotationVidroTra.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationVidroTra.maxRot, self.rotationVidroTra.minRot, 3, self.rotationVidroTra.rotTime, dt, not self.rotationMaxVidroTra);
				setRotation(self.rotationVidroTra.node, unpack(newRot));
			end;
			if self.rotationEmbraiagem ~= nil then
				local x, y, z = getRotation(self.rotationEmbraiagem.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationEmbraiagem.maxRot, self.rotationEmbraiagem.minRot, 3, self.rotationEmbraiagem.rotTime, dt, not self.rotationMaxEmbraiagem);
				setRotation(self.rotationEmbraiagem.node, unpack(newRot));
			end;
			if self.rotationAcelerador ~= nil then
				local x, y, z = getRotation(self.rotationAcelerador.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationAcelerador.maxRot, self.rotationAcelerador.minRot, 3, self.rotationAcelerador.rotTime, dt, not self.rotationMaxAcelerador);
				setRotation(self.rotationAcelerador.node, unpack(newRot));
			end;
			if self.rotationTravoes ~= nil then
				local x, y, z = getRotation(self.rotationTravoes.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationTravoes.maxRot, self.rotationTravoes.minRot, 3, self.rotationTravoes.rotTime, dt, not self.rotationMaxTravoes);
				setRotation(self.rotationTravoes.node, unpack(newRot));
			end;
	end;		
end;

function MovingParts:draw()

  
end;


function MovingParts:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MovingParts:setRotationMaxPortaEsq(rotationMaxPortaEsq, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetDoorLeftRotationEvent:new(self, rotationMaxPortaEsq), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorLeftRotationEvent:new(self, rotationMaxPortaEsq));
          end;
      end;
      self.rotationMaxPortaEsq = rotationMaxPortaEsq;
end;

function MovingParts:setRotationMaxPortaDta(rotationMaxPortaDta, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetDoorRightRotationEvent:new(self, rotationMaxPortaDta), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorRightRotationEvent:new(self, rotationMaxPortaDta));
          end;
      end;
      self.rotationMaxPortaDta = rotationMaxPortaDta;
end;

function MovingParts:setRotationMaxVidroTra(rotationMaxVidroTra, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetVidroTraRotationEvent:new(self, rotationMaxVidroTra), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetVidroTraRotationEvent:new(self, rotationMaxVidroTra));
          end;
      end;
      self.rotationMaxVidroTra = rotationMaxVidroTra;
end;