--
-- By PeterJ (03-03-2011)
--


Genesis = {};

function Genesis.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Genesis:load(xmlFile)
	self.pesos = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pesos#index"));

	self.kinkJoint = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.kinkSteering#kinkJoint"), 0);
	self.kinkOrientation = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kinkSteering#wheelOrientation"));

	self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;

    setVisibility(self.pesos, true);

    self.hudInfoBasePosX = 0.87;
    self.hudInfoBaseWidth = 0.12;
    self.hudInfoBasePosY = 0.4;
    self.hudInfoBaseHeight = 0.46;
    self.infoPanelPath = Utils.getFilename("material/help.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
    self.showHudInfoBase = false;

end;

function Genesis:keyEvent(unicode, sym, modifier, isDown)

	if self.isEntered then 
		if isDown and sym == Input.KEY_KP_0 then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;

end;

function Genesis:update(dt)
	if self.isMotorStarted then
		if self.kinkJoint ~= 0 then
			setJointFrame(self.componentJoints[self.kinkJoint].jointIndex , 0, self.componentJoints[self.kinkJoint].jointNode);   
			local x, y, z = getRotation(self.kinkOrientation);	    
			setRotation(self.kinkOrientation, 0,y,0);
		end;
	end;

	if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
end;

function Genesis:updateTick(dt)

	if self:getIsActive() then	
		if self.backHydraulic ~= nil then
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);			
		end;
	end;
end;

function Genesis:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function Genesis:draw()

		if self.showHudInfoBase then	
			g_currentMission:addExtraPrintText("Key Numpad 0:                                  Menu Off");
		else
			g_currentMission:addExtraPrintText("Key Numpad 0:                                  Menu On");
		end;

	if self.showHudInfoBase and self.isEntered then
		self.hudInfoBaseOverlay:render();
	end;

end;

function Genesis:onEnter()
end;

function Genesis:onLeave()
end;

function Genesis:delete()
	if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
end;

function Genesis:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Genesis:attachImplement(implement)
	
	local implementType = implement.object.attacherJoint.jointType;
	
	if implementType == Vehicle.JOINTTYPE_FRONTLOADER then
		setVisibility(self.pesos, false);
	end;
end;

function Genesis:detachImplement(implementIndex)

	setVisibility(self.pesos, true);
end;

function Genesis:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

