--
-- sTr
--
-- M@D Author  StarT,     Edit: Silak_68 (04/08/2013)
-- M@D date  16.12.2011
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --


sTr = {}

function sTr.prerequisitesPresent(specializations)
	Vehicle.registerJointType("fuelTrailer");
    return true ;
end;

function sTr:load(xmlFile)

local rotationPartNodebortPrav = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bortPrav#index"));
    if rotationPartNodebortPrav ~= nil then
        self.rotationPartbortPrav = {};
        self.rotationPartbortPrav.node = rotationPartNodebortPrav;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bortPrav#minRot"));
        self.rotationPartbortPrav.minRot = {};
        self.rotationPartbortPrav.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbortPrav.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbortPrav.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bortPrav#maxRot"));
        self.rotationPartbortPrav.maxRot = {};
        self.rotationPartbortPrav.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbortPrav.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbortPrav.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbortPrav.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bortPrav#rotTime"), 2)*1000;
        self.rotationPartbortPrav.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bortPrav#touchRotLimit"), 10));
    end;
	
	self.drivingParticleThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingParticles#threshold"), 0.005);
	local rotationPartNodebortLev = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bortLev#index"));
    if rotationPartNodebortLev ~= nil then
        self.rotationPartbortLev = {};
        self.rotationPartbortLev.node = rotationPartNodebortLev;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bortLev#minRot"));
        self.rotationPartbortLev.minRot = {};
        self.rotationPartbortLev.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbortLev.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbortLev.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bortLev#maxRot"));
        self.rotationPartbortLev.maxRot = {};
        self.rotationPartbortLev.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbortLev.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbortLev.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbortLev.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bortLev#rotTime"), 2)*1000;
        self.rotationPartbortLev.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bortLev#touchRotLimit"), 10));
    end;
end;
      
function sTr:delete()    
end;

function sTr:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function sTr:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_KP_0 then
	self.help = not self.help;
    end;
    
	if isDown and sym == Input.KEY_KP_4 then 
	self.rotationMaxbortLev = not self.rotationMaxbortLev;
	self.rotationMaxbortLev1 = not self.rotationMaxbortLev1;
    end;
	 
	if isDown and sym == Input.KEY_KP_5 then 
	self.rotationMaxbortPrav = not self.rotationMaxbortPrav;
	self.rotationMaxbortPrav1 = not self.rotationMaxbortPrav1;
    end;
end;

function sTr:update(dt)

	    if self.rotationPartbortPrav ~= nil then
		   local x, y, z = getRotation(self.rotationPartbortPrav.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbortPrav.maxRot, self.rotationPartbortPrav.minRot, 3, self.rotationPartbortPrav.rotTime, dt, not self.rotationMaxbortPrav);
		   setRotation(self.rotationPartbortPrav.node, unpack(newRot));
        end;
		
		if self.rotationPartbortLev ~= nil then
		   local x, y, z = getRotation(self.rotationPartbortLev.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbortLev.maxRot, self.rotationPartbortLev.minRot, 3, self.rotationPartbortLev.rotTime, dt, not self.rotationMaxbortLev);
		   setRotation(self.rotationPartbortLev.node, unpack(newRot));
        end;
end;

function sTr:draw()
        
		if self.help then
		renderText(0.76, 0.40, 0.02, g_i18n:getText("bortLev"));
		end;
		if self.help then
		renderText(0.76, 0.38, 0.02, g_i18n:getText("bortPrav"));
		end;
end;

function sTr:updateTick(dt)	

end;

function sTr:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
