RefillTrigger = {};

function RefillTrigger.prerequisitesPresent(specializations)
    return true;
end;

function RefillTrigger:load(xmlFile)
	self.manureTriggerCallback = RefillTrigger.manureTriggerCallback;
	self.trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Trigger#index"));	
	addTrigger(self.trigger, "manureTriggerCallback", self);
	self.deleteListenerId = addDeleteListener(self.trigger, "delete", self);
	self.fill = false;
	self.fillSpeed = 0.65;
	self.trailerInTrigger = nil;
end;

function RefillTrigger:delete()
	removeTrigger(self.trigger);
    removeDeleteListener(self.trigger, self.deleteListenerId);
end;

function RefillTrigger:readStream(streamId, connection)
	self.fill = streamReadBool(streamId);
end;

function RefillTrigger:writeStream(streamId, connection)
	streamWriteBool(streamId, self.fill);
end;

function RefillTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RefillTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function RefillTrigger:update(dt)
	local manureFill = self.fill;
		if self.trailerInTrigger ~= nil and self.fillLevel > 0 then
		if self:getIsActiveForInput() then		
			if self.trailerInTrigger.fillLevel < self.trailerInTrigger.capacity then
				if InputBinding.hasEvent(InputBinding.pesticideTrailer_ON)  then
					self.fill = not self.fill; 
				end;
				if self.fill then
					g_currentMission:addExtraPrintText(g_i18n:getText("pesticideTrailer_off").." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.pesticideTrailer_ON)); 
				else
					g_currentMission:addExtraPrintText(g_i18n:getText("pesticideTrailer_on" ).." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.pesticideTrailer_ON));
				end;
			end;
		end;
	end;
	if self.trailerInTrigger ~= nil and self.fillLevel > 0 then	
		if g_currentMission.controlledVehicle ~= nil then
			if self.trailerInTrigger.attacherVehicle == g_currentMission.controlledVehicle or self.trailerInTrigger == g_currentMission.controlledVehicle then
				if g_gui.currentGui == nil then
					if self.fill then
						g_currentMission:addExtraPrintText(g_i18n:getText("pesticideTrailer_off").." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.pesticideTrailer_ON)); 
					else
						g_currentMission:addExtraPrintText(g_i18n:getText("pesticideTrailer_on" ).." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.pesticideTrailer_ON));
					end;
					if InputBinding.hasEvent(InputBinding.pesticideTrailer_ON)  then
						self.fill = not self.fill; 
					end;
				end;
				
			end;
		end;
		local trailer = self.trailerInTrigger;
		if trailer.fillLevel < trailer.capacity then
			if g_server ~= nil then
				if self.fill then							
					local deltaFillLevel = dt*self.fillSpeed;
					trailer:setFillLevel(trailer.fillLevel+deltaFillLevel, self.currentFillType);
					self:setFillLevel(self.fillLevel-deltaFillLevel, self.currentFillType);
				end;
			end;
		else
			self.fill = false;
		end;
	else
		self.fill = false;
	end;
	if manureFill ~= self.fill then
		RefillTriggerEvent.sendEvent(self, self.fill);
	end;
end;

function RefillTrigger:updateTick(dt)
end;

function RefillTrigger:draw()	
		
end;

function RefillTrigger:onAttach(attacherVehicle)
end;

function RefillTrigger:onDetach()
end;

function RefillTrigger:manureTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    if onEnter then
		if otherId ~= nil then
			local trailer = g_currentMission.objectToTrailer[otherId];
			if trailer ~= nil then
				if trailer.fillTypes ~= nil and trailer.setFillLevel ~= nil and trailer.fillLevel ~= nil and trailer.rootNode ~= self.rootNode and trailer:allowFillType(self.currentFillType, true) then
					self.trailerInTrigger = trailer;
				end;
			end;
		end;		
	elseif onLeave then
		if otherId ~= nil then		
			local trailer = g_currentMission.objectToTrailer[otherId];
			if trailer ~= nil then
				if self.trailerInTrigger == trailer then
					self.trailerInTrigger = nil;
				end;
			end;
		end;
	end;
end;
------------------------------------------------------------ EVENT ------------------------------------------------------------
RefillTriggerEvent = {};
RefillTriggerEvent_mt = Class(RefillTriggerEvent, Event);

InitEventClass(RefillTriggerEvent, "RefillTriggerEvent");

function RefillTriggerEvent:emptyNew()
    local self = Event:new(RefillTriggerEvent_mt);
    self.className="RefillTriggerEvent";
    return self;
end;

function RefillTriggerEvent:new(object, data)
    local self = RefillTriggerEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function RefillTriggerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.data = streamReadBool(streamId);
	self.object.fill = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(RefillTriggerEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function RefillTriggerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.data);
end;

function RefillTriggerEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(RefillTriggerEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(RefillTriggerEvent:new(vehicle, data));
	end;
end;