SetTipModeEvent = {};
SetTipModeEvent_mt = Class(SetTipModeEvent, Event);

InitEventClass(SetTipModeEvent, "SetTipModeEvent");

function SetTipModeEvent:emptyNew()
    local self = Event:new(SetTipModeEvent_mt);
    self.className="SetTipModeEvent";
    return self;
end;

function SetTipModeEvent:new(vehicle, unloadSide)
    local self = SetTipModeEvent:emptyNew()
    self.vehicle = vehicle;
	self.unloadSide = unloadSide;
    return self;
end;

function SetTipModeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.unloadSide = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTipModeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt32(streamId, self.unloadSide);	
end;

function SetTipModeEvent:run(connection)
	self.vehicle:setTipMode(self.unloadSide, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetTipModeEvent:new(self.vehicle, self.unloadSide), nil, connection, self.object);
	end;
end;

function SetTipModeEvent.sendEvent(vehicle, unloadSide, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTipModeEvent:new(vehicle, unloadSide), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTipModeEvent:new(vehicle, unloadSide));
		end;
	end;
end;

SetLiftBoxEvent = {};
SetLiftBoxEvent_mt = Class(SetLiftBoxEvent, Event);

InitEventClass(SetLiftBoxEvent, "SetLiftBoxEvent");

function SetLiftBoxEvent:emptyNew()
    local self = Event:new(SetLiftBoxEvent_mt);
    self.className="SetLiftBoxEvent";
    return self;
end;

function SetLiftBoxEvent:new(vehicle, isBoxLifted)
    local self = SetLiftBoxEvent:emptyNew()
    self.vehicle = vehicle;
	self.isBoxLifted = isBoxLifted;
    return self;
end;

function SetLiftBoxEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isBoxLifted = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLiftBoxEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isBoxLifted);
end;

function SetLiftBoxEvent:run(connection)   
	self.vehicle:setLiftBox(self.isBoxLifted, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLiftBoxEvent:new(self.vehicle, self.isBoxLifted), nil, connection, self.vehicle);
    end;
end;

function SetLiftBoxEvent.sendEvent(vehicle, isBoxLifted, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLiftBoxEvent:new(vehicle, isBoxLifted), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLiftBoxEvent:new(vehicle, isBoxLifted));
		end;
	end;
end;