--
-- manureParticleFix
-- Specialization for Trailer allowing the particle to be displayed when unloading manure
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		01/12/2011
--

manureParticleFix = {}

function manureParticleFix.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function manureParticleFix:load(xmlFile)
      self.dischargeParticleSystems = {}
	local i = 0;
	while true do
		local key = string.format("vehicle.dischargeParticleSystems.part%d", i);
	local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};
      local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, self.baseDirectory)
      self.dischargeParticleSystems[desc.index] = currentPS;
			if self.addDefaultdischargeParticleSystems == nil then
				self.addDefaultdischargeParticleSystems = currentPS;
			end;
		end;
		i = i + 1;
	end;
end;

function manureParticleFix:delete()
end;

function manureParticleFix:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manureParticleFix:keyEvent(unicode, sym, modifier, isDown)
end;

function manureParticleFix:readStream(streamId, connection)
end;

function manureParticleFix:writeStream(streamId, connection)
end;

function manureParticleFix:readUpdateStream(streamId, timestamp, connection)
end;

function manureParticleFix:writeUpdateStream(streamId, connection, dirtyMask)
end;

function manureParticleFix:update(dt)
end;

function manureParticleFix:updateTick(dt)
end;

function manureParticleFix:draw()
end;

function manureParticleFix:setAddedParts(currentPart, noEventSend)
end;
