-- LUA fr den animierten Zylinder am Gassner Pflug
-- by modelleicher


gassnerZylinder = {};

function gassnerZylinder.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Plough, specializations);
end;
function gassnerZylinder:load(xmlFile)
	self.zylIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Zylinder#zylinderIndex"));
	self.stemIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Zylinder#stempelIndex"));
end;
function gassnerZylinder:delete()
end;
function gassnerZylinder:mouseEvent(posX, posY, isDown, isUp, button)
end;
function gassnerZylinder:keyEvent(unicode, sym, modifier, isDown)
end;
function gassnerZylinder:update(dt)
	if self:getIsActive() then
		if self.zylIndex ~= nil and self.stemIndex ~= nil then
			local a1x, a1y, a1z = getWorldTranslation(self.zylIndex);
			local b1x, b1y, b1z = getWorldTranslation(self.stemIndex);
			x1, y1, z1 = worldDirectionToLocal(getParent(self.zylIndex), b1x-a1x, b1y-a1y, b1z-a1z);
			setDirection(self.zylIndex, x1, y1, z1, 0, 1, 0);
			local a2x, a2y, a2z = getWorldTranslation(self.stemIndex);
			local b2x, b2y, b2z = getWorldTranslation(self.zylIndex);
			x2, y2, z2 = worldDirectionToLocal(getParent(self.stemIndex), b2x-a2x, b2y-a2y, b2z-a2z);
			setDirection(self.stemIndex, x2, y2, z2, 0, 1, 0);
		end;
	end;
end;
 function gassnerZylinder:draw()
end;
function gassnerZylinder:onDetach()
end;
function gassnerZylinder:onAttach()		
end; 


