﻿--
-- visibleChain
-- 
--
-- @author  pfreek
-- @date    07.10.2013
-- @support www.fuqsbow.com
--

visibleChain = {};

function visibleChain.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function visibleChain:load(xmlFile)

self.attachedChain = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attachedChain#index"));
self.detachedChain = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.detachedChain#index"));

end;

function visibleChain:delete()
end;

function visibleChain:mouseEvent(posX, posY, isDown, isUp, button)
end;

function visibleChain:keyEvent(unicode, sym, modifier, isDown)
end;

function visibleChain:attachImplement(implement)
	if  implement.object.attacherJoint.topReferenceNode ~= nil then
          	setVisibility(self.detachedChain, false);  
          	setVisibility(self.attachedChain, true);
	end;
end; 

function visibleChain:detachImplement(implementIndex)
	setVisibility(self.detachedChain, true);
	setVisibility(self.attachedChain, false);
end;

function visibleChain:update(dt)
end;

function visibleChain:updateTick(dt)
end;

function visibleChain:draw()
end;