--
-- CuttingAreasHelp
-- Class for the CuttingAreasHelp 
--
-- @author  Stefan Maurus - www.stefanmaurus.de
-- @date  19.03.2012
--
 
CuttingAreasHelp = {};
  
function CuttingAreasHelp.prerequisitesPresent(specializations)
      return true;
end;

function CuttingAreasHelp:load(xmlFile)
	self.setCuttingAreasHelpisOn = SpecializationUtil.callSpecializationsFunction("setCuttingAreasHelpisOn");

	self.startIndexHelp = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cuttingAreasHelp#startIndex"));	
	self.widthIndexHelp = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cuttingAreasHelp#widthIndex"));		
	self.CuttingAreasHelpisOn = false;	
end;

function CuttingAreasHelp:delete()
end;

function CuttingAreasHelp:readStream(streamId, connection) -- wird nur beim Joinen aufgerufen ;)
	self:setCuttingAreasHelpisOn(streamReadBool(streamId), true);	
end;

function CuttingAreasHelp:writeStream(streamId, connection) -- wird nur beim Joinen aufgerufen ;)
	streamWriteBool(streamId, self.CuttingAreasHelpisOn); 
end;

function CuttingAreasHelp:setCuttingAreasHelpisOn(bool, noEventSend)
	self.CuttingAreasHelpisOn = bool;
	SetCuttingAreasHelpisOnEvent.sendEvent(self, bool, noEventSend);
end;
 
function CuttingAreasHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function CuttingAreasHelp:keyEvent(unicode, sym, modifier, isDown)
end;
 
function CuttingAreasHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.CuttingAreasHelpOnOff) then
			self:setCuttingAreasHelpisOn(not self.CuttingAreasHelpisOn);	
		end;
	end;
end;

function CuttingAreasHelp:updateTick(dt)

	if self.CuttingAreasHelpisOn then
		 setVisibility(self.startIndexHelp, true)
		 setVisibility(self.widthIndexHelp, true)		 
	else
		 setVisibility(self.startIndexHelp, false)
		 setVisibility(self.widthIndexHelp, false)	
	end;
	
	--Left CuttingHelp
    local x3,y3,z3 = getTranslation(self.startIndexHelp);
    local x2,y2,z2 = getWorldTranslation(self.startIndexHelp);
    local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x2, 0, z2);
	local unterschied1 = y2-terrainHeight;
	if unterschied1 > 1 and unterschied1 < 1.1 then
		local New1y3 = y3-0.01;
		setTranslation(self.startIndexHelp, x3, New1y3, z3);	
	elseif unterschied1 > 1.1 and unterschied1 < 1.5 then
		local New2y3 = y3-0.05;
		setTranslation(self.startIndexHelp, x3, New2y3, z3);	
	elseif unterschied1 > 1.5 then
		local New3y3 = y3-0.2;
		setTranslation(self.startIndexHelp, x3, New3y3, z3);
	elseif unterschied1 < 1 and unterschied1 > 0.9 then
		local New4y3 = y3+0.01;
		setTranslation(self.startIndexHelp, x3, New4y3, z3);		
	elseif unterschied1 < 0.9 and unterschied1 > 0.5 then
		local New5y3 = y3+0.05;
		setTranslation(self.startIndexHelp, x3, New5y3, z3);	
	elseif unterschied1 < 0.5 then
		local New6y3 = y3+0.2;
		setTranslation(self.startIndexHelp, x3, New6y3, z3);			
	end;
		
	--Right CuttingHelp
    local x5,y5,z5 = getTranslation(self.widthIndexHelp);
    local x4,y4,z4 = getWorldTranslation(self.widthIndexHelp);
    local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x4, 0, z4);
	local unterschied = y4-terrainHeight;

	if unterschied > 1 and unterschied < 1.1 then
		local New1y5 = y5-0.01;
		setTranslation(self.widthIndexHelp, x5, New1y5, z5);	
	elseif unterschied > 1.1 and unterschied < 1.5 then
		local New2y5 = y5-0.05;
		setTranslation(self.widthIndexHelp, x5, New2y5, z5);	
	elseif unterschied > 1.5 then
		local New3y5 = y5-0.2;
		setTranslation(self.widthIndexHelp, x5, New3y5, z5);
	elseif unterschied < 1 and unterschied > 0.9 then
		local New4y5 = y5+0.01;
		setTranslation(self.widthIndexHelp, x5, New4y5, z5);		
	elseif unterschied < 0.9 and unterschied > 0.5 then
		local New5y5 = y5+0.05;
		setTranslation(self.widthIndexHelp, x5, New5y5, z5);	
	elseif unterschied < 0.5 then
		local New6y5 = y5+0.2;
		setTranslation(self.widthIndexHelp, x5, New6y5, z5);			
	end;
end;
 
function CuttingAreasHelp:draw()
	if not self.CuttingAreasHelpisOn then
		g_currentMission:addHelpButtonText(g_i18n:getText("CuttingAreasHelpTurnOn"), InputBinding.CuttingAreasHelpOnOff);		
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("CuttingAreasHelpTurnOff"), InputBinding.CuttingAreasHelpOnOff);
	end;
end;
 
function CuttingAreasHelp:onDetach()
end;

function CuttingAreasHelp:onLeave()
end;
 
function CuttingAreasHelp:onDeactivate()
end;
  
function CuttingAreasHelp:onDeactivateSounds()
end;

---------------------------------
-------------#######-------------
-------------#EVENT#-------------
-------------#######-------------
---------------------------------

SetCuttingAreasHelpisOnEvent = {};
SetCuttingAreasHelpisOnEvent_mt = Class(SetCuttingAreasHelpisOnEvent, Event);

InitEventClass(SetCuttingAreasHelpisOnEvent, "SetCuttingAreasHelpisOnEvent");

function SetCuttingAreasHelpisOnEvent:emptyNew()
    local self = Event:new(SetCuttingAreasHelpisOnEvent_mt);
    self.className="SetCuttingAreasHelpisOnEvent";
    return self;
end;

function SetCuttingAreasHelpisOnEvent:new(vehicle, CuttingAreasHelpisOn)
    local self = SetCuttingAreasHelpisOnEvent:emptyNew()
    self.vehicle = vehicle;
	self.CuttingAreasHelpisOn = CuttingAreasHelpisOn;
    return self;
end;

function SetCuttingAreasHelpisOnEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.CuttingAreasHelpisOn = streamReadBool(streamId);
	self.vehicle:setCuttingAreasHelpisOn(self.CuttingAreasHelpisOn, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetCuttingAreasHelpisOnEvent:new(self.vehicle, self.CuttingAreasHelpisOn), nil, connection, self.vehicle);
    end;
end;

function SetCuttingAreasHelpisOnEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.CuttingAreasHelpisOn);
end;


function SetCuttingAreasHelpisOnEvent.sendEvent(vehicle, CuttingAreasHelpisOn, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCuttingAreasHelpisOnEvent:new(vehicle, CuttingAreasHelpisOn), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCuttingAreasHelpisOnEvent:new(vehicle, CuttingAreasHelpisOn));
		end;
	end;
end;