﻿-- Lua for overloaded bunker in a trailer
-- first author unknown
-- edited by usxi7d 04-2013

Bunker = {};

function Bunker.prerequisitesPresent(specializations)
    return true;
end;

function Bunker:load(xmlFile)
		if self.isClient then
			self.dischargeParticleSystems = {}; 
			local i = 0;
            while true do
                local key = string.format("vehicle.dischargeParticleSystems.dischargeParticleSystem(%d)", i);
                local t = getXMLString(xmlFile, key .. "#type");
                if t == nil then
                    break;
                end;			
                local desc = FruitUtil.fruitTypes[t];
                if desc ~= nil then
                    local fillType = FruitUtil.fruitTypeToFillType[desc.index];
                    local currentPS = {};
   
                    local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
                    self.dischargeParticleSystems[fillType] = currentPS;
                    if self.defaultdischargeParticleSystems == nil then
                        self.defaultdischargeParticleSystems = currentPS;
                    end;
                end;				
                i = i + 1;
            end;
		end;	
	
	self.setSoundState = SpecializationUtil.callSpecializationsFunction("setSoundState");
	self.setUnloadingState = SpecializationUtil.callSpecializationsFunction("setUnloadingState");
	self.trailerRaycastCallback = Bunker.trailerRaycastCallback;

	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;

	self.unloadingSounds = {};
	self.unloadingSounds.startSound = {};
	local startSound = getXMLString(xmlFile, "vehicle.unloadingSounds#startFile");
    if startSound ~= nil and startSound ~= "" then
        startSound = Utils.getFilename(startSound, self.baseDirectory); 
        self.unloadingSounds.startSound.file = createSample("startSound");
        self.unloadingSounds.startSound.enabled = false;
		self.unloadingSounds.startSound.duration = getSampleDuration(self.unloadingSounds.startSound.file);
        loadSample(self.unloadingSounds.startSound.file, startSound, false);
    end;
	
	self.unloadingSounds.loopSound = {};
	local loopSound = getXMLString(xmlFile, "vehicle.unloadingSounds#loopFile");
    if loopSound ~= nil and loopSound ~= "" then
        loopSound = Utils.getFilename(loopSound, self.baseDirectory); 
        self.unloadingSounds.loopSound.file = createSample("loopSound");
        self.unloadingSounds.loopSound.enabled = false;
        loadSample(self.unloadingSounds.loopSound.file, loopSound, false);
    end;
	
	self.playLoopSoundTime = 0;
	
	self.triggerNode = {};
	self.triggerNode.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.unloadingTrigger#node"));
	self.triggerNode.distance = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.unloadingTrigger#maxDistance"), 1);
	self.unloadingTipTrigger = nil;
	
	self.pipe = {};
	self.pipe.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipebunker#index"));
	self.pipe.distance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipebunker#raycastDistanceBunker"), 7);
	self.pipe.out = false;
	
	self.unloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.unloadingCapacity"), 100);
	self.allowFillFromAir = true;
	self.isUnloading = false;
	
	self.isLoading = true;
	
	local path = Utils.getFilename("overlay.dds", self.baseDirectory);
    self.unloadingOverlay = Overlay:new("hudPDAControl", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY-0.11, g_currentMission.fruitSymbolSize, g_currentMission.fruitSymbolSize * (4 / 3)); 

	self.Capacity = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.capacity"));	
	self.rotorFan1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan1#index"));
	self.rotorFan2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan2#index"));
end;   -- load

function Bunker:delete()                      
	for _, particleSystem in pairs(self.dischargeParticleSystems) do  
           Utils.deleteParticleSystem(particleSystem);
    end;
	if self.unloadingSounds.loopSound.file ~= nil then
        delete(self.unloadingSounds.loopSound.file);
    end;
	if self.unloadingSounds.startSound.file ~= nil then
        delete(self.unloadingSounds.startSound.file);
    end;
end;

function Bunker:readStream(streamId, connection)
	self.isLoading = true;	
	local isUnloading = streamReadBool(streamId);
	self:setUnloadingState(isUnloading, true);
end;

function Bunker:writeStream(streamId, connection)        
	streamWriteBool(streamId, self.isUnloading);
end;

function Bunker:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Bunker:keyEvent(unicode, sym, modifier, isDown)
end;

function Bunker:update(dt)	
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.Bunker_6) then
				if self.pipe.out then
					self:setAnimationTime(1, self.animationParts[1].offSet, false);
					self:setUnloadingState(false);
				else
					self:setAnimationTime(1, self.animationParts[1].animDuration, false);
				end;
			end;
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then     
				self:setUnloadingState(not self.isUnloading);
			end;
		end;
	
		if self.animationParts[1].inputDone and self.animationParts[1].clipEndTime then
			self.pipe.out = true;
			if InputBinding.isPressed(InputBinding.Bunker_DOWN) and self:getIsActiveForInput() then
				self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
			elseif InputBinding.isPressed(InputBinding.Bunker_UP) and self:getIsActiveForInput() then
				self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
			end;
		elseif not self.animationParts[1].clipEndTime then
			self:setAnimationTime(2, self.animationParts[2].startPosition, false);
			self.pipe.out = false;
		end;
	
		local hydraulicSoundEnabled = false;
		for i=1, 2 do
			if not self.animationParts[i].inputDone then
				hydraulicSoundEnabled = true;
			end;
		end;
	
		if hydraulicSoundEnabled then
			if not self.hydraulicSoundEnabled and self.hydraulicSound ~= nil and self:getIsActiveForSound() then
				playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
				setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset-0.4);
				self.hydraulicSoundEnabled = true;   
			end;
		else
			if self.hydraulicSoundEnabled then
				stopSample(self.hydraulicSound);
				self.hydraulicSoundEnabled = false;   
			end;		
		end;
	
		if self:getIsActive() then	
			if self.fillLevel >= self.Capacity then
				self:setIsThreshing(false);
				self:stopAIThreshing(false);   
			end;
		end;
		
	--------------------------------------------------------------------------------------------	
		
		for i=1, table.getn(self.hydraulics) do
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
				if self.hydraulics[i].doScale then
					local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
					local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
					setScale(self.hydraulics[i].punch, 1, 1, newScale);
				else
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				end;
			end;
		end; -- do
	
		self.trailerFoundId = 0;
		self.unloadingTipTrigger = nil;
	
		if self.fillLevel > 0 and self.pipe.out and g_currentMission.tipTriggers ~= nil then
			for k, tipTrigger in pairs(g_currentMission.tipTriggers) do
				local trailerX, trailerY, trailerZ = getWorldTranslation(self.triggerNode.index);
				local triggerX, triggerY, triggerZ = getWorldTranslation(tipTrigger.triggerId);
				local distance = Utils.vector3Length(trailerX-triggerX, trailerY-triggerY, trailerZ-triggerZ);
				if distance < self.triggerNode.distance then
					self.unloadingTipTrigger = tipTrigger;
				end;
			end;
			if self.unloadingTipTrigger == nil then
				local x, y, z = getWorldTranslation(self.pipe.node);
				local dx, dy, dz = localDirectionToWorld(self.pipe.node, 0, -0.5, 0);
				raycastAll(x, y, z, dx, dy, dz, "trailerRaycastCallback", self.pipe.distance, self);
			end;
		end;	
	
		local renderOverlay = false;
		local deltaLevel = 0;
	
		if self.trailerFoundId ~= nil and self.trailerFoundId ~= 0 then		
			local trailer = g_currentMission.nodeToVehicle[self.trailerFoundId];
			if trailer ~= nil and trailer ~= self and trailer:allowFillType(self.currentFillType, true) and trailer.allowFillFromAir and trailer.capacity ~= trailer.fillLevel then			
				if self.isUnloading then
					deltaLevel = math.min(self.unloadingCapacity*dt/1000.0, trailer.capacity-trailer.fillLevel);
					trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
				else
					renderOverlay = true;
				end;			
			elseif self.isUnloading then
			self:setUnloadingState(false);
			end;
		end;
	
		self.fillLevel = self.fillLevel-deltaLevel;
	
		if deltaLevel == 0 and self.isUnloading then
			self.isUnloading = false;       
			Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.isUnloading);
			self:setUnloadingState(false);
		end;
	
		if self.fillLevel < 0 then 
			self.fillLevel = 0;
			self.isUnloading = false;       
			Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.isUnloading);
			self.currentFillType = Fillable.FRUITTYPE_UNKNOWN;
			self:setUnloadingState(self.isUnloading);
		end;
		
		if self.isUnloading then
			rotate(self.rotorFan1, dt*0.008, 0, 0);
			rotate(self.rotorFan2, dt*0.008, 0, 0);
		end;
		
		self:setFillLevel(self.fillLevel, self.currentFillType);
		self.renderOverlay = renderOverlay;
		Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.isUnloading);	
		self:setSoundState(self.isUnloading);
		self:setUnloadingState(self.isUnloading);
	else
		Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], false);
	    self:setUnloadingState(false);		
	end;
end;      ------------   update 


function Bunker:trailerRaycastCallback(transformId, x, y, z, distance)
	local vehicle = g_currentMission.nodeToVehicle[transformId];
	if vehicle ~= nil then
		if vehicle.exactFillRootNode == transformId then
			self.trailerFoundId = transformId;
			return false;
		end;
	end;
	return true;	
end;

function Bunker:setUnloadingState(state, noEventSend)            
	SetUnloadingEvent.sendEvent(self, state, noEventSend);
	self.isUnloading = state;
end;

function Bunker:setSoundState(value)
	if value == true then
		if not self.unloadingSounds.startSound.enabled and self:getIsActiveForSound() and self.unloadingSounds.startSound.file ~= nil then
			playSample(self.unloadingSounds.startSound.file, 1, 0.35, 0);
			setSamplePitch(self.unloadingSounds.startSound.file ,1);
			self.unloadingSounds.startSound.enabled = true;
			self.playLoopSoundTime = self.time + self.unloadingSounds.startSound.duration;
		end;
		if self.playLoopSoundTime <= self.time and not self.unloadingSounds.loopSound.enabled and self:getIsActiveForSound() and self.unloadingSounds.loopSound.file ~= nil then
			playSample(self.unloadingSounds.loopSound.file, 0, 0.35, 0);
			setSamplePitch(self.unloadingSounds.loopSound.file,1);
			self.unloadingSounds.loopSound.enabled  = true;
		end;
	else
		if self.unloadingSounds.loopSound.enabled and self.unloadingSounds.loopSound.file ~= nil then
			stopSample(self.unloadingSounds.loopSound.file);
			self.unloadingSounds.loopSound.enabled = false;
		end;
		if self.unloadingSounds.startSound.enabled and self.unloadingSounds.startSound.file ~= nil then
			stopSample(self.unloadingSounds.startSound.file);
			self.unloadingSounds.startSound.enabled = false;
		end;
	end;
end;

function Bunker:draw()	
	if self:getIsActiveForInput() and self:getIsActive() then
		if self.pipe.out then
			g_currentMission:addHelpButtonText(g_i18n:getText("Bunker_1"), InputBinding.Bunker_6);                  
			if self.animationParts[1].inputDone then
				g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.Bunker_UP) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.Bunker_DOWN)..":                 "..g_i18n:getText("Bunker_2")..""));
				if self.isUnloading then
					g_currentMission:addHelpButtonText(g_i18n:getText("Bunker_4"), InputBinding.IMPLEMENT_EXTRA4);  
				elseif self.renderOverlay then
					self.unloadingOverlay:render();
					g_currentMission:addHelpButtonText(g_i18n:getText("Bunker_3"), InputBinding.IMPLEMENT_EXTRA4);  
				end;
			end;
		else
		g_currentMission:addHelpButtonText(g_i18n:getText("Bunker_5"), InputBinding.Bunker_6);                   
		end;
	end;	
end;

function Bunker:onAttach(attacherVehicle)
end;

function Bunker:onDetach()  
end;

function Bunker:onLeave()                                        
	if self.deactivateOnLeave then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	--for _, particleSystem in pairs(self.dischargeParticleSystems) do  
           --Utils.deleteParticleSystem(particleSystem);
    --end;
	--print("onLeave");
end;

function Bunker:onDeactivate()                             
	self:setUnloadingState(false);
	self.unloadingTipTrigger = nil;
    self:onDeactivateSounds(self);
	self.isUnloading = false;
	--print("onDeactive");
end;

function Bunker:onDeactivateSounds()
	self:setSoundState(false);
end;

-----------------------------------------  SetUnloadingEvent ---------------------------------------------------------------------

SetUnloadingEvent = {};
SetUnloadingEvent_mt = Class(SetUnloadingEvent, Event);

InitEventClass(SetUnloadingEvent, "SetUnloadingEvent");

function SetUnloadingEvent:emptyNew()
    local self = Event:new(SetUnloadingEvent_mt);
    self.className = "SetUnloadingEvent";
    return self;
end;

function SetUnloadingEvent:new(object, isUnloading)
    local self = SetUnloadingEvent:emptyNew()
    self.object = object;
	self.isUnloading = isUnloading;
    return self;
end;

function SetUnloadingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isUnloading = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetUnloadingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isUnloading);
end;

function SetUnloadingEvent:run(connection)
	self.object:setUnloadingState(self.isUnloading, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetUnloadingEvent:new(self.object, self.isUnloading), nil, connection, self.object);
    end;	
end;

function SetUnloadingEvent.sendEvent(vehicle, isUnloading, noEventSend)
	if isUnloading ~= vehicle.isUnloading then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetUnloadingEvent:new(vehicle, isUnloading), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetUnloadingEvent:new(vehicle, isUnloading));
			end;
		end;
	end;
end;
