--
-- FrankenlandMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

FrankenlandMap = {}

local FrankenlandMap_mt = Class(FrankenlandMap, Mission00);


function FrankenlandMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = FrankenlandMap_mt;
    end;
    local self = FrankenlandMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function FrankenlandMap:delete()
    FrankenlandMap:superClass().delete(self);
end;

function FrankenlandMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function FrankenlandMap:loadMap01Finished(node, arguments)

	self.terrainDetailAngleNumChannels = 8; 
	
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("FrankenlandMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

       -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), - 500, - 900, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), - 721, - 958.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), - 521.1, - 902.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 500, 860, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), - 495, - 163, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), - 278, 891, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    FrankenlandMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function FrankenlandMap:onStartMission()
    FrankenlandMap:superClass().onStartMission(self);
end;

function FrankenlandMap:mouseEvent(posX, posY, isDown, isUp, button)
    FrankenlandMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function FrankenlandMap:keyEvent(unicode, sym, modifier, isDown)
    FrankenlandMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function FrankenlandMap:update(dt)
    FrankenlandMap:superClass().update(self, dt);
end;

function FrankenlandMap:draw()
    FrankenlandMap:superClass().draw(self);
end;