--
-- RansomesHR33
-- Specialization Ransomes HR33 disc.
--
-- @author  	PeterJ - FS_UK modteam
-- @version 	v1.0
-- @date  		19/02/2013
--

RansomesHR33 = {};

function RansomesHR33.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function RansomesHR33:load(xmlFile)

	self.liftAnimation = SpecializationUtil.callSpecializationsFunction("liftAnimation");
	self.liftBodyAnimation = getXMLString(xmlFile, "vehicle.liftAnimation#animationName");
	self.isBodyLifted = true;
	
	self.groundContactTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.liftAnimation#groundContactTime"), 0.2);
	self.AIoperated = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.liftAnimation#AIoperated"), true);
	
	self.visibleWheel = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.wheels.visibleWheel(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local fakeWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
		if fakeWheel ~= nil then
			table.insert(self.visibleWheel, {node=fakeWheel, speed=speed});
		end;
		i = i + 1;
	end;
	
	
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		self.hydraulics[i].invertZ = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName.."#invertZ"), false);
		self.hydraulics[i].scaleZ = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName.."#scaleZ"), false);
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		if self.hydraulics[i].scaleZ then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);		
			self.hydraulics[i].localReferenceDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
end;

function RansomesHR33:readStream(streamId, connection)
    self:liftAnimation(streamReadBool(streamId), true);
end;

function RansomesHR33:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isBodyLifted);
end;

function RansomesHR33:delete()
end;

function RansomesHR33:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local isBodyLifted = getXMLBool(xmlFile, key.."#bodyUp");
	if isBodyLifted ~= nil then
		self:liftAnimation(isBodyLifted);
		self.firstTime = false;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function RansomesHR33:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'bodyUp="'..tostring(self.isBodyLifted)..'"';
	return attributes, nil;
end;

function RansomesHR33:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RansomesHR33:keyEvent(unicode, sym, modifier, isDown)
end;

function RansomesHR33:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self:liftAnimation(not self.isBodyLifted);
			end;
		end;
	end;

	if self.visibleWheel ~= nil then
		for _, fakeWheel in pairs(self.visibleWheel) do
			local x,y,z = getRotation(self.wheels[1].driveNode);	
			setRotation(fakeWheel.node, x*fakeWheel.speed, 0, 0);
		end;
	end;
	
	if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;
	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
end;

function RansomesHR33:updateTick(dt)
	if self:getIsActive() then
		if self:getAnimationTime(self.liftBodyAnimation) == 0 then
			if not self.isBodyLifted then
				if self.onlyActiveWhenLowered then
					self.onlyActiveWhenLowered = false;
				end;
			end;
		else
			if self:getAnimationTime(self.liftBodyAnimation) > self.groundContactTime then
				if not self.onlyActiveWhenLowered then
					self.onlyActiveWhenLowered = true;
				end;
			else
				if self.onlyActiveWhenLowered then
					self.onlyActiveWhenLowered = false;
				end;
			end;
		end;
	end;
end;

function RansomesHR33:draw()
	if self:getIsActive() then  
		if self:getIsActiveForInput(true) then
			if self.isBodyLifted then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lower"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lift"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
	end;
end;

function RansomesHR33:onAttach(attacherVehicle)
end;
 
function RansomesHR33:onDetach()
end;

function RansomesHR33:liftAnimation(isBodyLifted,noEventSend)
	SetLiftBodyEvent.sendEvent(self, isBodyLifted, noEventSend);
	self.isBodyLifted = isBodyLifted;
	if self.isBodyLifted then
		if self.liftBodyAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.liftBodyAnimation, 1, nil, true);
		end;
	else
		if self.liftBodyAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.liftBodyAnimation, -1, nil, true);
		end;
	end;
end;

function RansomesHR33:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		if hydraulic.invertZ then
			x = -x;
			y = -y;
			z = -z;
		end;
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
		if hydraulic.scaleZ and hydraulic.localReferenceDistance ~= nil then
			local len = Utils.vector3Length(x, y, z);
			setScale(hydraulic.node, 1, 1, len/hydraulic.localReferenceDistance);
		end
	end;
end;

function RansomesHR33:aiTurnOn()
	if self.liftBodyAnimation ~= nil and self.playAnimation ~= nil then
		self:playAnimation(self.liftBodyAnimation, -1, nil, true);
		self.isBodyLifted = false;
	end;
end;
function RansomesHR33:aiTurnOff()
	if self.liftBodyAnimation ~= nil and self.playAnimation ~= nil then
		self:playAnimation(self.liftBodyAnimation, 1, nil, true);
		self.isBodyLifted = true;
	end;
end;

function RansomesHR33:aiLower()
	if self.liftBodyAnimation ~= nil and self.playAnimation ~= nil then
		self:playAnimation(self.liftBodyAnimation, -1, nil, true);
		self.isBodyLifted = false;
	end;
end;

function RansomesHR33:aiRaise()
	if self.liftBodyAnimation ~= nil and self.playAnimation ~= nil then
		self:playAnimation(self.liftBodyAnimation, 1, nil, true);
		self.isBodyLifted = true;
	end;
end;

SetLiftBodyEvent = {};
SetLiftBodyEvent_mt = Class(SetLiftBodyEvent, Event);

InitEventClass(SetLiftBodyEvent, "SetLiftBodyEvent");

function SetLiftBodyEvent:emptyNew()
    local self = Event:new(SetLiftBodyEvent_mt);
    self.className="SetLiftBodyEvent";
    return self;
end;

function SetLiftBodyEvent:new(vehicle, isBodyLifted)
    local self = SetLiftBodyEvent:emptyNew()
    self.vehicle = vehicle;
	self.isBodyLifted = isBodyLifted;
    return self;
end;

function SetLiftBodyEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isBodyLifted = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLiftBodyEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isBodyLifted);
end;

function SetLiftBodyEvent:run(connection)   
	self.vehicle:liftAnimation(self.isBodyLifted, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLiftBodyEvent:new(self.vehicle, self.isBodyLifted), nil, connection, self.vehicle);
    end;
end;

function SetLiftBodyEvent.sendEvent(vehicle, isBodyLifted, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLiftBodyEvent:new(vehicle, isBodyLifted), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLiftBodyEvent:new(vehicle, isBodyLifted));
		end;
	end;
end;
