 --
-- Fraese
-- Specialization for Fraese
--
-- @author  Christian Moser
-- @date  26/06/14

-- Copyright (C) Chrisu70, Confidential, All Rights Reserved.
-- Großer DANK an upsidedown für die unterstützung!!!!!!!





 Fraese = {};
   
 
  source("dataS/scripts/vehicles/specializations/SetTurnedOnEvent.lua");
  
 
  
  function Fraese.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(Attachable, specializations);
  end;
   
     
   function Fraese:load(xmlFile)
   
	   self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	   self.isTurnedOn = false;
       self.setPipeState = SpecializationUtil.callSpecializationsFunction("setPipeState");
       self.findAutoAimTrailerToUnload = Fraese.findAutoAimTrailerToUnload;
       self.findTrailerToUnload = Fraese.findTrailerToUnload;
       self.findTrailerRaycastCallback = Fraese.findTrailerRaycastCallback;
       self.getFraeseTrailerInRangePipeState = Fraese.getFraeseTrailerInRangePipeState;
	   self.getIsPipeStateChangeAllowed = Fraese.getIsPipeStateChangeAllowed;
       self.getIsPipeUnloadingAllowed = Fraese.getIsPipeUnloadingAllowed;
       self.onFraeseTrailerTrigger = Fraese.onFraeseTrailerTrigger;
       self.resetFillLevelIfNeeded = Fraese.resetFillLevelIfNeeded;
	   self.capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 200);
       self.unloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.unloadingCapacity"), 10);
       self.fillShovelFromGroundValue = Utils.overwrittenFunction(self.fillShovelFromGroundValue, Fraese.fillShovelFromGroundValue);
       self.fillShovelFromTrigger = Utils.overwrittenFunction(self.fillShovelFromTrigger, Fraese.fillShovelFromTrigger);
       self.setIsTurnedOn = Fraese.setIsTurnedOn;
       self.getAllowFillShovel = Utils.overwrittenFunction(self.getAllowFillShovel, Fraese.getAllowFillShovel);
	   self.fraeseLastfraeseTime = -10000;
	   self:addConflictCheckedInput(InputBinding.EMPTY_GRAIN);
	   self.setTransRot = SpecializationUtil.callSpecializationsFunction("setTransRot");
	   self.TransRotAnimation = getXMLString(xmlFile, "vehicle.TransRot#animationName");
	   self.TransRot = false;
	   
	  local pipeSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
          if pipeSound ~= nil and pipeSound ~= "" then
              pipeSound = Utils.getFilename(pipeSound, self.baseDirectory);
              self.pipeSound = createSample("pipeSound");
              loadSample(self.pipeSound, pipeSound, false);
              self.pipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchOffset"), 1);
              self.pipeSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#volume"), 1);
              setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
          end;
  
	  local aiTrailerTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiTrailerTrigger#index"));
      if aiTrailerTrigger ~= nil then
          print("Warning: aiTrailerTrigger is no longer supported. Use vehicle.FraeseTrailerTriggers.FraeseTrailerTrigger instead");
      end
      if hasXMLProperty(xmlFile, string.format("vehicle.aiTrailerTriggers.aiTrailerTrigger(%d)", 0)) then
          print("Warning: aiTrailerTriggers are no longer supported. Use vehicle.FraeseTrailerTriggers.FraeseTrailerTrigger instead");
      end
 
	  self.FraeseTrailerTriggers = {};
  
      local i = 0;
      while true do
          local key = string.format("vehicle.FraeseTrailerTriggers.FraeseTrailerTrigger(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              local pipeState = Utils.getNoNil(getXMLInt(xmlFile, key.."#pipeState"), 2);
              self.FraeseTrailerTriggers[node] = {node=node, pipeState=pipeState};
          end;
          i = i + 1;
      end;
      for _, trigger in pairs(self.FraeseTrailerTriggers) do
          addTrigger(trigger.node, "onFraeseTrailerTrigger", self);
      end;
	   
	  self.fraeseTrailersInRange = {};
	  
	  
	  self.foldMaxPipeState = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.pipe#foldMaxState"), 999);
      self.foldMinPipeState = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.pipe#foldMinState"), 0);	
      self.pipeNodes = {};
      self.numPipeStates = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.pipe#numStates"), 0);
      self.currentPipeState = 1;
      self.targetPipeState = 1;
      self.pipeStateIsUnloading = {};
      self.pipeStateIsAutoAiming = {};
	  
	  
      local unloadingPipeStates = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.pipe#unloadingStates"));
      if unloadingPipeStates ~= nil then
          for i=1, table.getn(unloadingPipeStates) do
              if unloadingPipeStates[i] ~= nil then
                  self.pipeStateIsUnloading[unloadingPipeStates[i] ] = true;
              end;
          end;
      end;
      local autoAimPipeStates = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.pipe#autoAimStates"));
      if autoAimPipeStates ~= nil then
         for i=1, table.getn(autoAimPipeStates) do
             if autoAimPipeStates[i] ~= nil then
                  self.pipeStateIsAutoAiming[autoAimPipeStates[i] ] = true;
              end;
          end;
      end;
     local i = 0;
      while true do
         local key = string.format("vehicle.pipe.node(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              local entry = {};
              entry.node = node;
              entry.autoAimXRotation = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimXRotation"), false);
              entry.autoAimYRotation = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimYRotation"), false);
              entry.autoAimInvertZ = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimInvertZ"), false);
              entry.states = {};
              for state=1,self.numPipeStates do
                  local stateKey = key..string.format(".state%d", state);
                  entry.states[state] = {};
                  local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, stateKey.."#translation"));
                  if x == nil or y == nil or z == nil then
                      x,y,z = getTranslation(node);
                  end;
                  entry.states[state].translation = {x,y,z};
                  local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, stateKey.."#rotation"));
                  if x == nil or y == nil or z == nil then
                      x,y,z = getRotation(node);
                  else
                      x,y,z = math.rad(x),math.rad(y),math.rad(z);
                  end;
                  entry.states[state].rotation = {x,y,z};
              end;
              local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translationSpeeds"));
              if x ~= nil and y ~= nil and z ~= nil then
                  x,y,z = x*0.001,y*0.001,z*0.001;
                  if x ~= 0 or y ~= 0 or z ~= 0 then
                      entry.translationSpeeds = {x,y,z};
                  end;
              end;
              local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotationSpeeds"));
              if x ~= nil and y ~= nil and z ~= nil then
                  x,y,z = math.rad(x)*0.001,math.rad(y)*0.001,math.rad(z)*0.001;
                  if x ~= 0 or y ~= 0 or z ~= 0 then
                      entry.rotationSpeeds = {x,y,z};
                  end;
              end;
  
              local x,y,z = getTranslation(node);
              entry.curTranslation = {x,y,z};
              local x,y,z = getRotation(node);
              entry.curRotation = {x,y,z};
              table.insert(self.pipeNodes, entry);
          end;
          i = i + 1;
     end;
      if table.getn(self.pipeNodes) == 0 then
          -- use the old format
  
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
          if node ~= nil then
              self.numPipeStates = 2;
  
              local entry = {};
              entry.node = node;
              entry.states = {};
              entry.states[1] = {};
              entry.states[2] = {};
  
              local x,y,z = getRotation(node);
              entry.states[1].rotation = {0,0,z};
              entry.states[2].rotation = {math.rad(10),math.rad(-90),z};
  
              entry.rotationSpeeds = {0.00006, 0.0006, 0};
  
              local x,y,z = getRotation(node);
              entry.curRotation = {x,y,z};
  
              table.insert(self.pipeNodes, entry);
  
              self.pipeStateIsUnloading[2] = true;
          end;
      end;
  
      local pipeFlapLid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeFlapLid#index"));
      if pipeFlapLid ~= nil then
          if self.numPipeStates ~= 2 then
              print("Error: pipeFlapLid is only support with 2 pipe states in '"..self.configFileName.."'.");
          else
              print("Warning: using deprecated feature pipeFlapLid. Use multiple pipe nodes instead");
              local entry = {};
              entry.node = pipeFlapLid;
              entry.states = {};
              entry.states[1] = {};
              entry.states[2] = {};
  
             entry.states[1].rotation = {0,0,0};
              entry.states[2].rotation = {0,math.rad(-90),0};
  
              entry.rotationSpeeds = {0, 0.0006, 0};
  
              local x,y,z = getRotation(pipeFlapLid);
              entry.curRotation = {x,y,z};
  
              table.insert(self.pipeNodes, entry);
          end;
      end;
  
      self.pipeRaycastNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#raycastNodeIndex"));
	  self.pipeRaycastDistance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#raycastDistance"), 7);
	  self.pipeParticleSystemExtraDistance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeParticleSystems#extraDistance"), 1.5);
  
      self.pipeParticleSystems = {};
 
      -- load the pipe particle system for each fruit type
      local i = 0;
      while true do
          local key = string.format("vehicle.pipeParticleSystems.pipeParticleSystem(%d)", i);
          local t = getXMLString(xmlFile, key .. "#type");
          if t == nil then
              break;
          end;
  
          local desc = Fillable.fillTypeNameToDesc[t];
          if desc ~= nil then
              local currentPS = {};
  
              local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory, defaultPipePSNode);
  
              for _, v in ipairs(currentPS) do
                  local normalSpeed,tangentSpeed = getParticleSystemAverageSpeed(v.geometry);
                  v.speed = math.sqrt(normalSpeed*normalSpeed + tangentSpeed*tangentSpeed);
                  v.originalLifespan = getParticleSystemLifespan(v.geometry);
              end
              self.pipeParticleSystems[desc.index] = currentPS;
              if self.defaultPipeParticleSystem == nil then
                  self.defaultPipeParticleSystem = currentPS;
              end;
  
              if self.pipeRaycastNode == nil then
                  self.pipeRaycastNode = particleNode;
              end;
          end;
          i = i + 1;
      end;
      if self.pipeRaycastNode == nil then 
          self.pipeRaycastNode = self.components[1].node;
      end;
	  
	 
      self.pipeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight#index"));
	  self.pipeIsUnloading = false;
      self.pipeParticleDeactivateTime = -1;
	 
     
		self.rotateFraese = {};
		local i=0;
		while true do
			local baseName = string.format("vehicle.fraeseRotatingParts.fraeseRotatingPart(%d)", i);
			local index = getXMLString(xmlFile, baseName.. "#index");
			local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.. "#rotationSpeed"));
			local rotationSpeed = {x,y,z};
			local runOutTime = Utils.getNoNil(getXMLFloat(xmlFile, baseName.. "#runOutTime"), 2)*1000;
			if index == nil or rotationSpeed == nil or runOutTime == nil then
				break;
			end;
			local node = Utils.indexToObject(self.components, index);
			if node ~= nil then
				local entry = {};
				entry.node = node;
				entry.runOutTime = runOutTime;
				entry.rotationSpeedMax = rotationSpeed;
				entry.rotationSpeedMin = {0,0,0};
				entry.rotationSpeedCurrent = {0,0,0};
				table.insert(self.rotateFraese, entry);
			end;
			i = i+1;
		end;	
		
		self.isTurnedOn = false;
		self.fraeseNeedsTurnOn = false;
		if self.shovelNodes ~= nil then
		self.fraeseNeedsTurnOn = true;
		end
	
	 
--[[ Sound ]]
      self.fraeseSoundEnabled = false;
      if self.isClient then
          local fraeseSound = getXMLString(xmlFile, "vehicle.fraeseSound#file");
          if fraeseSound ~= nil and fraeseSound ~= "" then
              fraeseSound = Utils.getFilename(fraeseSound, self.baseDirectory);
              self.fraeseSound = createSample("fraeseSound");
              loadSample(self.fraeseSound, fraeseSound, false);
              self.fraeseSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fraeseSound#pitchOffset"), 1);
              self.fraeseSoundfraesePitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fraeseSound#fraesePitchOffset"), 0.8*self.fraeseSoundPitchOffset);
              self.fraeseSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fraeseSound#volume"), 1.0);
              setSamplePitch(self.fraeseSound, self.fraeseSoundPitchOffset);
          end;
  
          local fraeseStartSound = getXMLString(xmlFile, "vehicle.fraeseStartSound#file");
          if fraeseStartSound ~= nil and fraeseStartSound ~= "" then
              fraeseStartSound = Utils.getFilename(fraeseStartSound, self.baseDirectory);
              self.fraeseStartSound = createSample("fraeseStartSound");
              loadSample(self.fraeseStartSound, fraeseStartSound, false);
              self.fraeseStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fraeseStartSound#pitchOffset"), 1);
              self.fraeseStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fraeseStartSound#volume"), 1.0);
              setSamplePitch(self.fraeseStartSound, self.fraeseStartSoundPitchOffset);
          end;
  
          local fraeseStopSound = getXMLString(xmlFile, "vehicle.fraeseStopSound#file");
          if fraeseStopSound ~= nil and fraeseStopSound ~= "" then
              fraeseStopSound = Utils.getFilename(fraeseStopSound, self.baseDirectory);
              self.fraeseStopSound = createSample("fraeseStopSound");
              loadSample(self.fraeseStopSound, fraeseStopSound, false);
              self.fraeseStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fraeseStopSound#pitchOffset"), 1);
              self.fraeseStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fraeseStopSound#volume"), 1.0);
              setSamplePitch(self.fraeseStopSound, self.fraeseStopSoundPitchOffset);
          end;
       end
		self.fraeseParticleSystems = {}
		local i = 0
			while true do
		do
			local key = string.format("vehicle.fraeseParticleSystems.fraeseParticleSystem(%d)", i)
			local t = getXMLString(xmlFile, key .. "#type")
				if t == nil then
				break
				end
			local desc = Fillable.fillTypeNameToDesc[t]
				if desc ~= nil then
					local currentPS = {}
					local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory)
        
				self.fraeseParticleSystems[desc.index] = currentPS
					if self.defaultFraeseParticleSystem == nil then
					self.defaultFraeseParticleSystem = currentPS
					end
        
				end
				i = i + 1
			end
		end
  
		self.fraeseParticleDeactivateTime = -1
		self.DirtyFlag = self:getNextDirtyFlag();
		self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
		self.saveMinRpm = 0; 
  end;    
  
  function Fraese:delete()
	  
	  for _, aiTrailerTrigger in pairs(self.FraeseTrailerTriggers) do
          removeTrigger(aiTrailerTrigger.node);
      end;
  
      for _,v in pairs(self.pipeParticleSystems) do
          Utils.deleteParticleSystem(v);
      end;
      if self.pipeSound ~= nil then
          delete(self.pipeSound);
      end;
      
      if self.fraeseSound ~= nil then
          delete(self.fraeseSound);
      end
      if self.fraeseStartSound ~= nil then
          delete(self.fraeseStartSound);
      end
      if self.fraeseStopSound ~= nil then
          delete(self.fraeseStopSound);
      end
	  for _, v in pairs(self.fraeseParticleSystems) do
    Utils.deleteParticleSystem(v)
	end
  end;
  
   function Fraese:readStream(streamId, connection)
	  local turnedOn = streamReadBool(streamId);
	  self:setIsTurnedOn(turnedOn, true);
      local fillLevel = streamReadFloat32(streamId);
      local fillType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
	  self.currentFillType = streamReadInt8(streamId);
      self:setTransRot(streamReadBool(streamId), true);
	  local pipeState = streamReadUIntN(streamId, 3);
      local pipeUnloadingDistance = streamReadUIntN(streamId, 5);
      if pipeUnloadingDistance == 0 then
          self.pipeIsUnloading = false;
      else
          self.pipeIsUnloading = true;
          self.pipeUnloadingDistance = pipeUnloadingDistance*self.pipeRaycastDistance / 31;
      end
	  self:setPipeState(pipeState, true);
     
      
  end;
  
  function Fraese:writeStream(streamId, connection)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.isTurnedOn);
		streamWriteUIntN(streamId, self.currentFillType, FruitUtil.sendNumBits);
		streamWriteUIntN(streamId, self.targetPipeState, 3);
		streamWriteBool(streamId, self.TransRot);
		if self.pipeIsUnloading then
			streamWriteUIntN(streamId, Utils.clamp(math.floor(self.pipeUnloadingDistance/self.pipeRaycastDistance*31), 1, 31), 5);
		else
			streamWriteUIntN(streamId, 0, 5);
		end
     end;
  end;
  function Fraese:readUpdateStream(streamId, timestamp, connection)
      if connection:getIsServer() then
          if streamReadBool(streamId) then
			local fillLevel = streamReadUInt16(streamId)/65535*self.capacity;
            local fillType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
			 	
			  
              local pipeUnloadingDistance = streamReadUIntN(streamId, 5);
              if pipeUnloadingDistance == 0 then
                  self.pipeIsUnloading = false;
              else
                  self.pipeIsUnloading = true;
                 self.pipeUnloadingDistance = pipeUnloadingDistance*self.pipeRaycastDistance / 31;
              end
              
           end;
       end;
   end;

  
  function Fraese:writeUpdateStream(streamId, connection, dirtyMask)
        if not connection:getIsServer() then
			if streamWriteBool(streamId, bitAND(dirtyMask, self.DirtyFlag) ~= 0) then
              local percent = 0;
              if self.capacity > 0 then
                  percent = Utils.clamp(self.fillLevel / self.capacity, 0, 1);
              end;
              streamWriteUInt16(streamId, math.floor(percent*65535));
             
              streamWriteUIntN(streamId, self.currentFillType, FruitUtil.sendNumBits);
              if self.pipeIsUnloading then
                  streamWriteUIntN(streamId, Utils.clamp(math.floor(self.pipeUnloadingDistance/self.pipeRaycastDistance*31), 1, 31), 5);
              else
                  streamWriteUIntN(streamId, 0, 5);
              end
             
        end;
	end;	
  end
  
  
  
  function Fraese:mouseEvent(posX, posY, isDown, isUp, button)
  end;
  
  function Fraese:keyEvent(unicode, sym, modifier, isDown)
  end;

  function Fraese:update(dt)
      if self.isActive then	
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
  
				if self.fraeseNeedsTurnOn then
					if self:getIsActiveForInput() then
						if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
							self:setIsTurnedOn(not self.isTurnedOn);
							self:setTransRot(not self.isTransRotOn);
						end
					end
				end
			if InputBinding.hasEvent(InputBinding.EMPTY_GRAIN) then
                  local nextState = self.targetPipeState+1;
                  if nextState > self.numPipeStates then
                      nextState = 1;
                  end;
                  if self:getIsPipeStateChangeAllowed(nextState) then
                      self:setPipeState(nextState);
                  elseif nextState ~= 1 and self:getIsPipeStateChangeAllowed(1) then
                      
                      self:setPipeState(1);
                  end
            end;
        end;
		
		
		if self.isTurnedOn then
					
					for k, fraese in ipairs(self.rotateFraese) do
						local values = Utils.getMovedLimitedValues(fraese.rotationSpeedCurrent, fraese.rotationSpeedMax, fraese.rotationSpeedMin, 3, fraese.runOutTime, dt, not self.isTurnedOn);
						fraese.rotationSpeedCurrent = values;
						rotate(fraese.node, unpack(fraese.rotationSpeedCurrent));
					end;

                   if not self.fraeseSoundEnabled and self.fraeseSound ~= nil and self:getIsActiveForSound() then
                      if self.fraeseStartSound == nil or not isSamplePlaying(self.fraeseStartSound) or getSamplePlayOffset(self.fraeseStartSound) >= getSampleDuration(self.fraeseStartSound)-1.8*dt then
                          playSample(self.fraeseSound, 0, self.fraeseSoundVolume, 0);
                          self.fraeseSoundEnabled = true;
                      end
                  end
                  if self.fraeseSoundEnabled then
                      if self.fraeseLastfraeseTime >= self.time-200 then
                          setSamplePitch(self.fraeseSound, self.fraeseSoundfraesePitchOffset);
                      else
                          setSamplePitch(self.fraeseSound, self.fraeseSoundPitchOffset);
                      end;
                  end
              
			else
				if self.isClient and self.fraeseSoundEnabled and self.fraeseSound ~= nil and self:getIsActiveForSound() then
					stopSample(self.fraeseSound);
					self.fraeseSoundEnabled = false;
				end;
			end;
			
		if self.isClient then	
			if self.isTurnedOn and self.fillLevel > 0 then
			self.fraeseParticleDeactivateTime = self.time + 200
			do
				local currentFraeseParticleSystem = self.fraeseParticleSystems[self.currentFillType]
				if currentFraeseParticleSystem == nil then
				currentFraeseParticleSystem = self.defaultFraeseParticleSystem
				end
				if currentFraeseParticleSystem ~= self.currentFraeseParticleSystem then
				Utils.setEmittingState(self.currentFraeseParticleSystem, false)
				self.currentFraeseParticleSystem = currentFraeseParticleSystem
				Utils.setEmittingState(self.currentFraeseParticleSystem, true)
				end
			end
			elseif 0 <= self.fraeseParticleDeactivateTime and self.fraeseParticleDeactivateTime <= self.time then
			self.fraeseParticleDeactivateTime = -1
			if self.currentFraeseParticleSystem ~= nil then
				Utils.setEmittingState(self.currentFraeseParticleSystem, false)
				self.currentFraeseParticleSystem = nil
			end
		end
	end
			
				
		
		  local doAutoAiming = self.pipeStateIsAutoAiming[self.currentPipeState];
          local targetTrailer = nil;
          if doAutoAiming then
		  
              targetTrailer = self:findAutoAimTrailerToUnload(self.currentFillType);
  
              if targetTrailer == nil then
			  
                  doAutoAiming = false;
              end;
          end;
          if (self.currentPipeState ~= self.targetPipeState or doAutoAiming) and self.targetPipeState <= self.numPipeStates then
              local autoAimX, autoAimY, autoAimZ;
              if doAutoAiming then
                  autoAimX, autoAimY, autoAimZ = getWorldTranslation(targetTrailer.fillAutoAimTargetNode);
              end;
  
  
              local moved = false;
              for i=1, table.getn(self.pipeNodes) do
                  local nodeMoved = false; 
                  local pipeNode = self.pipeNodes[i];
  
                  local state = pipeNode.states[self.targetPipeState];
                  if pipeNode.translationSpeeds ~= nil then 
                      for i=1, 3 do
                          if pipeNode.curTranslation[i] ~= state.translation[i] then
                              nodeMoved = true; 
                              if pipeNode.curTranslation[i] < state.translation[i] then
                                  pipeNode.curTranslation[i] = math.min(pipeNode.curTranslation[i] + dt*pipeNode.translationSpeeds[i], state.translation[i]);
                              else
                                  pipeNode.curTranslation[i] = math.max(pipeNode.curTranslation[i] - dt*pipeNode.translationSpeeds[i], state.translation[i]);
                              end;
                          end;
                      end;
                      setTranslation(pipeNode.node, pipeNode.curTranslation[1],pipeNode.curTranslation[2],pipeNode.curTranslation[3])
                  end;
                  if pipeNode.rotationSpeeds ~= nil then
                      for i=1, 3 do
                          local targetRotation = state.rotation[i];
                          if doAutoAiming then
                              if pipeNode.autoAimXRotation and i == 1 then
                                  local x,y,z = getWorldTranslation(pipeNode.node);
                                  local x,y,z = worldDirectionToLocal(getParent(pipeNode.node), autoAimX-x, autoAimY-y, autoAimZ-z);
                                  targetRotation = -math.atan2(y,z);
                                  if pipeNode.autoAimInvertZ then
                                      targetRotation = targetRotation+math.pi;
                                  end;
                                  targetRotation = Utils.normalizeRotationForShortestPath(targetRotation, pipeNode.curRotation[i]);
                              elseif pipeNode.autoAimYRotation and i == 2 then
                                  local x,y,z = getWorldTranslation(pipeNode.node);
                                  local x,y,z = worldDirectionToLocal(getParent(pipeNode.node), autoAimX-x, autoAimY-y, autoAimZ-z);
                                  targetRotation = math.atan2(x,z);
                                  if pipeNode.autoAimInvertZ then
                                      targetRotation = targetRotation+math.pi;
                                  end;
                                  targetRotation = Utils.normalizeRotationForShortestPath(targetRotation, pipeNode.curRotation[i]);
                              end;
                          end;
                          if pipeNode.curRotation[i] ~= targetRotation then
                              nodeMoved = true; 
                              if pipeNode.curRotation[i] < targetRotation then
                                  pipeNode.curRotation[i] = math.min(pipeNode.curRotation[i] + dt*pipeNode.rotationSpeeds[i], targetRotation);
                              else
                                  pipeNode.curRotation[i] = math.max(pipeNode.curRotation[i] - dt*pipeNode.rotationSpeeds[i], targetRotation);
                              end;
                          end;
                      end;
                      setRotation(pipeNode.node, pipeNode.curRotation[1],pipeNode.curRotation[2],pipeNode.curRotation[3])
                  end;
                  moved = moved or nodeMoved;
  
                  if nodeMoved and self.setMovingToolDirty ~= nil then
				 
                      self:setMovingToolDirty(pipeNode.node);
                  end;
              end;
              if not moved then
                  self.currentPipeState = self.targetPipeState;
				  
              end;
          end;
  
          if self.isClient then
              if self.currentPipeState ~= self.targetPipeState then
                  if self.pipeSound ~= nil and not self.pipeSoundEnabled then
                      if self:getIsActiveForSound() then
                          playSample(self.pipeSound, 0, self.pipeSoundVolume, 0);
                          self.pipeSoundEnabled = true;
                      end;
                  end;
              else
                  if self.pipeSoundEnabled then
                      stopSample(self.pipeSound);
                      self.pipeSoundEnabled = false;
                  end;
              end;
          end;
		end;  
 end
 

  
  function Fraese:updateTick(dt)
        if self.isServer then
             
		  self:setVehicleRpmUp(dt, self.isTurnedOn);
          self.pipeIsUnloading = false;
          if self.pipeStateIsUnloading[self.currentPipeState] --[[ and self:getIsPipeUnloadingAllowed() ]] then
              if self.fillLevel > 0 then
				
								
                  -- test if we should drain the grain tank
                  local trailer, trailerDistance = self:findTrailerToUnload(self.currentFillType); 
                  if trailer == nil then 
                      self.pipeIsUnloading = false;
					 
                  else
						
                     local fillType = self.currentFillType;
                      trailer:resetFillLevelIfNeeded(self.currentFillType); 
					 
  
                      local deltaLevel = self.fillLevel;
                      if self.capacity > 0 then
                          deltaLevel = math.min(self.fillLevel, self.unloadingCapacity*dt/1000.0);
                      end;
                      deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
                      if deltaLevel > 0 then
                          self.pipeIsUnloading = true; 
                          self.pipeUnloadingDistance = trailerDistance;
  
                          self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
                          trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
						  
                      end
                  end;
              end;
          end;
	    
	
		  if self.capacity <= 0 then
              self.lastLostfillLevel = self.fillLevel;
              if self.fillLevel > 0 then
                  self:setFillLevel(0, self.currentFillType);
              end
          end
  
          if (self.capacity > 0 and (self.fillLevel ~= self.sentfillLevel or self.currentFillType ~= self.sentFillType)) or
               self.pipeIsUnloading ~= self.sentPipeIsUnloading or self.pipeUnloadingDistance ~= self.sentPipeUnloadingDistance 
              
          then
              self:raiseDirtyFlags(self.DirtyFlag);
              self.sentfillLevel = self.fillLevel;
              self.sentFillType = self.currentFillType;
              self.sentLastValidFillType = self.lastValidFillType;
              self.sentPipeIsUnloading = self.pipeIsUnloading;
              self.sentPipeUnloadingDistance = self.pipeUnloadingDistance;
              
          end;
	

		if self.isClient then
           if self.pipeIsUnloading then
              self.pipeParticleDeactivateTime = self.time + 200;
              local currentPipeParticleSystem = self.pipeParticleSystems[self.currentFillType];
              if currentPipeParticleSystem == nil then
                  currentPipeParticleSystem = self.defaultPipeParticleSystem;
              end;
              if currentPipeParticleSystem ~= self.currentPipeParticleSystem then
                  Utils.setEmittingState(self.currentPipeParticleSystem, false);
  
                  self.currentPipeParticleSystem = currentPipeParticleSystem;
                  Utils.setEmittingState(self.currentPipeParticleSystem, true);
              end
  
              if self.currentPipeParticleSystem ~= nil then
                  for _, v in ipairs(self.currentPipeParticleSystem) do
                      local lifespan = math.min(v.originalLifespan, (self.pipeUnloadingDistance+self.pipeParticleSystemExtraDistance)/v.speed);
                      setParticleSystemLifespan(v.geometry, lifespan, true);
                  end
              end
  

          else
              if self.pipeParticleDeactivateTime >= 0 and self.pipeParticleDeactivateTime <= self.time then
                  self.pipeParticleDeactivateTime = -1;
                  if self.currentPipeParticleSystem ~= nil then
                      Utils.setEmittingState(self.currentPipeParticleSystem, false);
                      self.currentPipeParticleSystem = nil;
                  end
  

                end
            end
        end
	end;  
end;

  
  
  function Fraese:draw()
		if self.isClient then
			local percent = 0;
          if self.capacity > 0 then
             percent = self.fillLevel / self.capacity*100;
          if self.currentPipeState == 2 and not self.pipeIsUnloading and self.fillLevel > 0 then
                  g_currentMission:addExtraPrintText(g_i18n:getText("Bewege Pipe über Anhänger"));
               elseif self.fillLevel == self.capacity then
                  g_currentMission:addExtraPrintText(g_i18n:getText("Fördere"));
              end;
          end;
          if self.fraeseNeedsTurnOn then
              if self.isTurnedOn then
                  g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
              else
                  g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
              end;
          end
          if self.numPipeStates == 2 then
              if self.targetPipeState == 2 then
                  if self:getIsPipeStateChangeAllowed(1) then
                      g_currentMission:addHelpButtonText(g_i18n:getText("Pipe_in"), InputBinding.EMPTY_GRAIN);
                  end
              else
                  if self:getIsPipeStateChangeAllowed(2) and (percent > 0 or self.capacity <= 0) then
                      g_currentMission:addHelpButtonText(g_i18n:getText("Dump_corn"), InputBinding.EMPTY_GRAIN);
                  end
              end
          end;
		end;
     end;     
 
  function Fraese:onDetach()
	  Utils.setEmittingState(self.currentFraeseParticleSystem, false)
      if self.deactivateOnDetach then
          Fraese.onDeactivate(self);
      else
          Fraese.onDeactivateSounds(self);
      end;
	  for k, steerable in pairs(g_currentMission.steerables) do
        if self.attacherVehicleCopy == steerable then
            steerable.motor.minRpm = self.saveMinRpm;
            self.attacherVehicleCopy = nil;
        end;
    end;	
	 
  end;
  
  function Fraese:onAttach(attacherVehicle)
    
    if self.attacherVehicleCopy == nil then
        self.attacherVehicleCopy = self.attacherVehicle;
    end;
    self.saveMinRpm = self.attacherVehicle.motor.minRpm;	
	end;
  
  function Fraese:setVehicleRpmUp(dt, isActive)
    if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
        if dt ~= nil then
            if isActive == true then
                self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1500);
            else
                self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
            end;
        else
            self.attacherVehicle.motor.minRpm = self.saveMinRpm;
        end;
        if self.attacherVehicle.isMotorStarted then
            local fuelUsed = 0.000000001*math.abs(self.attacherVehicle.motor.minRpm);
            self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
            g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
            g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
        end;
    end;
  end;
  
  function Fraese:onLeave()
      Utils.setEmittingState(self.currentFraeseParticleSystem, false)
	  if self.deactivateOnLeave then
          Fraese.onDeactivate(self);
      else
          Fraese.onDeactivateSounds(self);
      end;
  end;
  
  function Fraese:onDeactivate()
	  Utils.setEmittingState(self.currentFraeseParticleSystem, false)
      self:setIsTurnedOn(false, true)
      Fraese.onDeactivateSounds(self)
	  self.isTurnedOn = false;
  end;
  
  function Fraese:onDeactivateSounds()
      if self.fraeseSoundEnabled then
          stopSample(self.fraeseSound);
          self.fraeseSoundEnabled = false;
      end
	  if self.pipeSound ~= nil and self.pipeSoundEnabled then
          stopSample(self.pipeSound);
          self.pipeSoundEnabled = false;
      end;
  end;
  
  function Fraese:setIsTurnedOn(isTurnedOn, noEventSend)
      SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend)
      if self.isTurnedOn ~= isTurnedOn then
          self.isTurnedOn = isTurnedOn;
  
          if self.isClient then
              if self.fraeseStartSound ~= nil then
                  stopSample(self.fraeseStartSound);
              end
              if self.fraeseStopSound ~= nil then
                  stopSample(self.fraeseStopSound);
              end
  
              if self:getIsActiveForSound() then
                  if self.isTurnedOn then
                      if self.fraeseStartSound ~= nil then
                          playSample(self.fraeseStartSound, 1, self.fraeseStartSoundVolume, 0);
                      end
                  else
                      if self.fraeseStopSound ~= nil then
                          playSample(self.fraeseStopSound, 1, self.fraeseStopSoundVolume, 0);
                      end
                  end
              end
			  
          end
      end
  end;
  
  function Fraese:setTransRot(isTransRot,noEventSend)
	SetTransRotEvent.sendEvent(self, isTransRot, noEventSend);
	-- Play TransRot animation --
	self.isTransRotOn = isTransRot;
	if self.isTransRotOn then
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, 1, nil, true);
			self.TransRot = true;

		end;
	else
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, -1, nil, true);
			self.TransRot = false;
	
		end;
	end;
  end;
  
  function Fraese:getAllowFillShovel(superFunc, fillType)
      if self.isTurnedOn then
          if superFunc ~= nil then
             return superFunc(self, fillType);
          end
      end
      return false;
  end;
 
  
 function Fraese:resetFillLevelIfNeeded(fillType)
  
      if self.currentFillType ~= fillType then
          self.fillLevel = 0;
      end;
  end;
  
   function Fraese:getIsPipeStateChangeAllowed(pipeState)
      if pipeState ~= 1 and self.foldAnimTime ~= nil and (self.foldAnimTime > self.pipeFoldMaxLimit or self.foldAnimTime < self.pipeFoldMinLimit) then
          return false; 
		  
      end
      return true;
  end
  
  function Fraese:getIsPipeUnloadingAllowed()
      if self.foldAnimTime ~= nil and (self.foldAnimTime > self.pipeFoldMaxLimit or self.foldAnimTime < self.pipeFoldMinLimit) then
          return false; 
		  
      end
      return true;
  end
  
 
  function Fraese:setPipeState(pipeState, noEventSend)
      pipeState = math.min(pipeState, self.numPipeStates);
      if self.targetPipeState ~= pipeState then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetPipeStateEvent:new(self, pipeState));
              else
                  g_client:getServerConnection():sendEvent(SetPipeStateEvent:new(self, pipeState), nil, nil, self);
              end;
          end;
          self.targetPipeState = pipeState;
          self.currentPipeState = 0;
      end;
  end;
 
  function Fraese:getIsFoldAllowed(superFunc)
      
	  if self.foldAnimTime ~= nil and (self.fillLevel > self.foldMaxFillLevel or self.fillLevel < self.foldMinFillLevel) then
          return false;
      end
	  	  
      if self.currentPipeState > self.foldMaxPipeState or self.currentPipeState < self.foldMinPipeState then
          return false;
      end
  
      if superFunc ~= nil then
          return superFunc(self);
      end
      return true;
  end
 
   function Fraese:findAutoAimTrailerToUnload(fillType)
     local trailer = nil; 
      local smallestTrailerId = nil;
      local trailerIsAttached = false; 
      for trailerInRange, pipeStage in pairs(self.fraeseTrailersInRange) do
	
          if trailerInRange.isDeleted then 
              self.fraeseTrailersInRange[trailerInRange] = nil;
          else
              if trailerInRange:allowFillType(self.currentFillType) and trailerInRange.getAllowFillFromAir ~= nil and trailerInRange:getAllowFillFromAir() and trailerInRange.fillLevel < trailerInRange.capacity then
                 
				 local id = networkGetObjectId(trailerInRange);
				 local isAttached = trailerInRange:getIsAttachedTo(self)
				  
                  if trailer == nil or (isAttached and not trailerIsAttached) or (isAttached == trailerIsAttached and id < smallestTrailerId) then
                      trailer = trailerInRange;
                      smallestTrailerId = id;
                      trailerIsAttached = isAttached
                  end;
              end;
          end
      end;
      return trailer;
  end;
  
  function Fraese:findTrailerToUnload(fillType)
  
      local x,y,z = getWorldTranslation(self.pipeRaycastNode);
      local dx,dy,dz = localDirectionToWorld(self.pipeRaycastNode, 0,-1,0);
  
     self.trailerFound = 0;	
      self.trailerFoundDistance = 0;
      raycastAll(x, y, z, dx,dy,dz, "findTrailerRaycastCallback", self.pipeRaycastDistance, self);
  
      local trailer = g_currentMission.nodeToVehicle[self.trailerFound]; 
      if trailer == nil or not trailer:allowFillType(self.currentFillType) or trailer.getAllowFillFromAir == nil or not trailer:getAllowFillFromAir() or trailer.fillLevel >= trailer.capacity then
          return nil; 
      end;
      return trailer, self.trailerFoundDistance;
	  
  end;
  
  function Fraese:findTrailerRaycastCallback(transformId, x, y, z, distance)
  
      local vehicle = g_currentMission.nodeToVehicle[transformId];
      if vehicle ~= nil then
	  
          if vehicle.exactFillRootNode == transformId then 
              self.trailerFound = transformId;
              self.trailerFoundDistance = distance;
              return false; 
          end;
      end;
  
      return true;
  
  end;
  
  function Fraese:getFraeseTrailerInRangePipeState()
      local maxPipeState = 0;
      for trailer, pipeState in pairs(self.fraeseTrailersInRange) do
          if trailer.isDeleted then
              self.fraeseTrailersInRange[trailer] = nil;
			  
          else
              maxPipeState = math.max(maxPipeState, pipeState);
			  
          end
      end;
      return maxPipeState;
  end
  
  function Fraese:onEnter(isControlling)
  end;
  
  function Fraese:onFraeseTrailerTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
      if onEnter or onLeave then
          local trailer = g_currentMission.nodeToVehicle[otherId];
          if trailer ~= nil and trailer.fillRootNode ~= nil and trailer ~= self then 
              if onEnter then  
                  self.fraeseTrailersInRange[trailer] = self.FraeseTrailerTriggers[triggerId].pipeState;
              else
                  self.fraeseTrailersInRange[trailer] = nil;
              end;
          end;
      end;
  end;
  
 
 function Fraese:fillShovelFromGroundValue(superFunc, areas, fillType)
      local value = false;
      if superFunc ~= nil then
          value = superFunc(self, areas, fillType)
      end
      if value then
          self.fraeseLastfraeseTime = self.time;
      end
      return value;
  end
  
  function Fraese:fillShovelFromTrigger(superFunc, shovelTrigger, deltaFillLevel, fillType, dt)
      local value = 0;
      if superFunc ~= nil then
          value = superFunc(self, shovelTrigger, deltaFillLevel, fillType, dt)
      end
      if value > 0 then
          self.fraeseLastfraeseTime = self.time;
      end
      return value;
  end
  
  
  
  
 SetPipeStateEvent = {};
  SetPipeStateEvent_mt = Class(SetPipeStateEvent, Event);
  
 
  
  function SetPipeStateEvent:emptyNew()
      local self = Event:new(SetPipeStateEvent_mt);
      return self;
  end;
  
  function SetPipeStateEvent:new(object, pipeState)
      local self = SetPipeStateEvent:emptyNew()
      self.object = object;
      self.pipeState = pipeState;
      assert(self.pipeState >= 0 and self.pipeState < 8);
      return self;
  end;
  
  function SetPipeStateEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.pipeState = streamReadUIntN(streamId, 3);
      self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function SetPipeStateEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteUIntN(streamId, self.pipeState, 3);
  end;
  
  function SetPipeStateEvent:run(connection)
      self.object:setPipeState(self.pipeState, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetPipeStateEvent:new(self.object, self.pipeState), nil, connection, self.object);
      end;
  end 
  
SetTransRotEvent = {};
SetTransRotEvent_mt = Class(SetTransRotEvent, Event);

InitEventClass(SetTransRotEvent, "SetTransRotEvent");

function SetTransRotEvent:emptyNew()
    local self = Event:new(SetTransRotEvent_mt);
    self.className="SetTransRotEvent";
    return self;
end;

function SetTransRotEvent:new(vehicle, isTransRot)
    local self = SetTransRotEvent:emptyNew()
    self.vehicle = vehicle;
	self.isTransRot = isTransRot;
    return self;
end;

function SetTransRotEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isTransRot = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTransRotEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isTransRot);
end;

function SetTransRotEvent:run(connection)   
	self.vehicle:setTransRot(self.isTransRot, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTransRotEvent:new(self.vehicle, self.isTransRot), nil, connection, self.vehicle);
    end;
end;

function SetTransRotEvent.sendEvent(vehicle, isTransRot, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTransRotEvent:new(vehicle, isTransRot), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTransRotEvent:new(vehicle, isTransRot));
		end;
	end;
end;
  

  
  