--
-- Fortuna
-- Specialization for Fortuna
--
-- @author  Manuel Leithner
-- @date  26/07/09
--

Fortuna = {};

function Fortuna.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Fortuna:load(xmlFile)
	self.PlayerInRange = Fortuna.PlayerInRange;
	self.pillar = {};
	self.anlegeKl = {};
	self.anlegeKl[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.anlegeklotz#index1"));
	self.anlegeKl[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.anlegeklotz#index2"));
	
	self.pillar.nodeRot = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pillar#indexRot"));
	self.pillar.node = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pillar#index"));
	self.pillar.colli = Utils.getNoNil(getXMLInt(xmlFile,"vehicle.pillar#Colli"),1);
	self.pillar.minTrans = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.pillar#minTrans"),"0 0 0"))};
	self.pillar.maxTrans = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.pillar#maxTrans"),"0 0 0"))};
	self.pillar.MoveTime = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.pillar#MoveTime"),5)*1000;
	
	setVisibility(self.anlegeKl[1], true);
	setVisibility(self.anlegeKl[2], false);
	
end;

function Fortuna:delete()
end;

function Fortuna:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fortuna:keyEvent(unicode, sym, modifier, isDown)
end;

function Fortuna:update(dt)
	if not self:getIsActive() then
		local playerInRange = self:PlayerInRange();
		if playerInRange == true then
			g_currentMission:addHelpButtonText(g_i18n:getText("up"), InputBinding.FRONTLOADER_TILT_POS);
			g_currentMission:addHelpButtonText(g_i18n:getText("down"), InputBinding.FRONTLOADER_TILT_NEG);
			local up = nil;
			if InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POS) then
				up = true;
			end;
			if InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEG) then
				up = false;
			end;
			if up ~= nil then
				local newTrans = Utils.getMovedLimitedValues({getTranslation(self.pillar.node)}, self.pillar.minTrans, self.pillar.maxTrans, 3, self.pillar.MoveTime , dt, up);
				setTranslation(self.pillar.node,unpack(newTrans));
				local x,y,z = getTranslation(self.pillar.node);
				if y <= self.pillar.minTrans[2] or y >= self.pillar.minTrans[2] then
					setJointFrame(self.componentJoints[self.pillar.colli].jointIndex, 0,self.componentJoints[self.pillar.colli].jointNode);
					if up == true then
						rotate(self.pillar.nodeRot,0,0,0.1);
					else
						rotate(self.pillar.nodeRot,0,0,-0.1);
					end;
				end;
			end;
		end;
	else
		g_currentMission.fixedCamera = false;
	end;
end;

function Fortuna:draw()
end;

function Fortuna:PlayerInRange()
	if g_currentMission.currentVehicle ~= nil then
		return false;
	else
		local x1,y1,z1 = getWorldTranslation(self.pillar.nodeRot);
		local x2,y2,z2 = getWorldTranslation(Player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance <= 1 then
			return true;
		else
			return false;
		end;	
	end;
end;


function Fortuna:onAttach(attacherVehicle)
	setVisibility(self.anlegeKl[1], true);
	setVisibility(self.anlegeKl[2], false);
end;

function Fortuna:onDetach()
	setVisibility(self.anlegeKl[2], true);
	setVisibility(self.anlegeKl[1], false);
end;




