--
-- PowerShaft
-- Specialization for PowerShaft
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @date  26/07/09
--
-- free for noncommerical-usage
--

PowerShaft = {};

function PowerShaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function PowerShaft:load(xmlFile)
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	self.powerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
	x,y,z = getTranslation(self.powerShaft.part);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft.part);
	local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
	self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.attacherVehiclePowerShaft = nil;
end;

function PowerShaft:delete()
end;

function PowerShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowerShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function PowerShaft:update(dt)
	if self:getIsActive() then	
		if self.attacherVehiclePowerShaft ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);		
		end;		
	end;
end;

function PowerShaft:draw()
end;

function PowerShaft:onAttached(attacherVehicle, jointDescIndex)
	local joint = attacherVehicle.attacherJoints[jointDescIndex];
	if joint.powerShaftAttacher ~= nil then
		self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
	end;
end;

function PowerShaft:onDetach()
	setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
	setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
end;




