-- NI Modding
--
-- author  	Henly20 
-- date  	15-04-2013.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com
--

dropbed = {};

function dropbed.prerequisitesPresent(specializations)
    return true;
end;

function dropbed:load(xmlFile)

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	self.setArmOne = SpecializationUtil.callSpecializationsFunction("setArmOne");
	self.ArmOneAnimation = getXMLString(xmlFile, "vehicle.armOne#animationName");
	self.ArmOne = false;

	self.setArmTwo = SpecializationUtil.callSpecializationsFunction("setArmTwo");
	self.ArmTwoAnimation = getXMLString(xmlFile, "vehicle.armTwo#animationName");
	self.ArmTwo = false;
	
	self.ramp = {};
	self.ramp.node = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ramp#indexramp"));

	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
    self.printWarningTime = 0;
	
end;

function dropbed:delete()
end;

function dropbed:readStream(streamId, connection)
    self:setArmOne(streamReadBool(streamId), true);
    self:setArmTwo(streamReadBool(streamId), true); 
end;

function dropbed:writeStream(streamId, connection)
	streamWriteBool(streamId, self.ArmOne);
	streamWriteBool(streamId, self.ArmTwo);
end;

function dropbed:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dropbed:keyEvent(unicode, sym, modifier, isDown)
end;

function dropbed:update(dt)

	if not self:getIsActive() then

		if self.RampsInRange and self.isArmOneOn then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setArmTwo(not self.isArmTwoOn);
			end;
			if self.isArmTwoOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rampoff"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rampon"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
	end;
	if self:getIsActiveForInput() then
		if not self.isArmTwoOn then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setArmOne(not self.isArmOneOn);
			end;
		end;
		if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA2) and self.isArmTwoOn then
			self.printWarningTime = self.time + 1500;
		end;		
	end;
	
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
end;

function dropbed:updateTick(dt)
	if g_currentMission.player ~= nil then
		local nearestDistance = 3.0;
		local x1,y1,z1 = getWorldTranslation(self.ramp.node);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.RampsInRange = true; 
		else
			self.RampsInRange = false; 
		end;
	end;
	if self:getIsActive() then
		
		self.setHydraulicTime = 30;	


		if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
		end;
	end;
	
end;

function dropbed:draw()
	if self:getIsActive() then
		if not self.isArmTwoOn then 
			if self.isArmOneOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("raise"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lower"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
		if self.printWarningTime > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;
	end;
end;

function dropbed:setArmOne(isArmOne,noEventSend)
	SetArmOneEvent.sendEvent(self, isArmOne, noEventSend);
	-- Play ArmOne animation --
	self.isArmOneOn = isArmOne;
	if self.isArmOneOn then
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, 1, nil, true);
			self.ArmOne = true;
		end;
	else
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, -1, nil, true);
			self.ArmOne = false;
		end;
	end;	
end;

function dropbed:setArmTwo(isArmTwo,noEventSend)
	SetArmTwoEvent.sendEvent(self, isArmTwo, noEventSend);
	-- Play ArmTwo animation --
	self.isArmTwoOn = isArmTwo;
	if self.isArmTwoOn then
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, 1, nil, true);
			self.ArmTwo = true;
		end;
	else
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, -1, nil, true);
			self.ArmTwo = false;
		end;
	end;	
end;

function dropbed:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;


function dropbed:validateAttacherJoint(implement, jointDesc, dt)
        return true;

end;

function dropbed:onDetach()

end;

function dropbed:onAttach(attacherVehicle)

end;

SetArmOneEvent = {};
SetArmOneEvent_mt = Class(SetArmOneEvent, Event);

InitEventClass(SetArmOneEvent, "SetArmOneEvent");

function SetArmOneEvent:emptyNew()
    local self = Event:new(SetArmOneEvent_mt);
    self.className="SetArmOneEvent";
    return self;
end;

function SetArmOneEvent:new(vehicle, isArmOne)
    local self = SetArmOneEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmOne = isArmOne;
    return self;
end;

function SetArmOneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmOne = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmOneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmOne);
end;

function SetArmOneEvent:run(connection)   
	self.vehicle:setArmOne(self.isArmOne, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmOneEvent:new(self.vehicle, self.isArmOne), nil, connection, self.vehicle);
    end;
end;

function SetArmOneEvent.sendEvent(vehicle, isArmOne, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmOneEvent:new(vehicle, isArmOne), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmOneEvent:new(vehicle, isArmOne));
		end;
	end;
end;

SetArmTwoEvent = {};
SetArmTwoEvent_mt = Class(SetArmTwoEvent, Event);

InitEventClass(SetArmTwoEvent, "SetArmTwoEvent");

function SetArmTwoEvent:emptyNew()
    local self = Event:new(SetArmTwoEvent_mt);
    self.className="SetArmTwoEvent";
    return self;
end;

function SetArmTwoEvent:new(vehicle, isArmTwo)
    local self = SetArmTwoEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmTwo = isArmTwo;
    return self;
end;

function SetArmTwoEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmTwo = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmTwoEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmTwo);
end;

function SetArmTwoEvent:run(connection)   
	self.vehicle:setArmTwo(self.isArmTwo, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmTwoEvent:new(self.vehicle, self.isArmTwo), nil, connection, self.vehicle);
    end;
end;

function SetArmTwoEvent.sendEvent(vehicle, isArmTwo, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmTwoEvent:new(vehicle, isArmTwo), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmTwoEvent:new(vehicle, isArmTwo));
		end;
	end;
end;